/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka.shell;

import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.SystemType;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="opennms-kafka-rpc", name="topics", description="List RPC topics used by current system.")
@Service
public class KafkaRpcTopics
implements Action {
    @Reference
    private Identity identity;
    @Reference
    private ConfigurationAdmin configAdmin;
    @Option(name="-t", aliases={"--timeout"}, description="Connection timeout for Kafka Server")
    private int timeout;

    public Object execute() throws Exception {
        Properties kafkaConfig = Utils.getKafkaConfig((Identity)this.identity, (ConfigurationAdmin)this.configAdmin, (String)"rpc");
        if (kafkaConfig.isEmpty() || kafkaConfig.getProperty("bootstrap.servers") == null) {
            System.out.println("Kafka not configured for RPC");
            return null;
        }
        if (this.timeout <= 0) {
            this.timeout = 60;
        }
        kafkaConfig.put("request.timeout.ms", (Object)this.timeout);
        try {
            Set topics = Utils.getTopics((Properties)kafkaConfig);
            if (!topics.isEmpty()) {
                String opennmsInstance = SystemInfoUtils.getInstanceId();
                String locationSuffix = "";
                if (this.identity.getType().equals(SystemType.Minion.name())) {
                    locationSuffix = "." + this.identity.getLocation();
                }
                String topicName = opennmsInstance + locationSuffix;
                Set<String> rpcRequestTopics = topics.stream().filter(topic -> topic.contains(topicName)).filter(topic -> topic.contains("rpc-request")).collect(Collectors.toSet());
                if (!rpcRequestTopics.isEmpty()) {
                    System.out.println("\nRPC Request Topics:");
                    rpcRequestTopics.forEach(System.out::println);
                } else {
                    System.out.println("No RPC Request topics found.");
                }
                Set<String> rpcResponseTopics = topics.stream().filter(topic -> topic.contains(opennmsInstance)).filter(topic -> topic.contains("rpc-response")).collect(Collectors.toSet());
                if (!rpcRequestTopics.isEmpty()) {
                    System.out.println("\nRPC Response Topics:");
                    rpcResponseTopics.forEach(System.out::println);
                } else {
                    System.out.println("No RPC Response topics found.");
                }
                return null;
            }
            System.out.println("No topics listed for Kafka RPC");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

