/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opennms.core.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class JaxbClassObjectAdapter
extends XmlAdapter<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbClassObjectAdapter.class);
    private final Map<String, Class<?>> m_knownElementClasses = new HashMap();

    public JaxbClassObjectAdapter() {
        LOG.debug("Initializing JaxbClassObjectAdapter.");
    }

    public JaxbClassObjectAdapter(Class<?> ... clazzes) {
        LOG.debug("Initializing JaxbClassObjectAdapter with {} classes.", (Object)clazzes.length);
        for (Class<?> clazz : clazzes) {
            XmlRootElement annotation = clazz.getAnnotation(XmlRootElement.class);
            if (annotation == null) continue;
            this.m_knownElementClasses.put(annotation.name().toLowerCase(), clazz);
        }
    }

    public Object unmarshal(Object from) throws Exception {
        LOG.trace("unmarshal: from = ({}){}", from == null ? null : from.getClass(), from);
        if (from == null) {
            return null;
        }
        if (from instanceof Node) {
            Node e = (Node)from;
            e.normalize();
            String nodeName = e.getNodeName();
            Class<?> clazz = this.getClassForElement(nodeName);
            LOG.trace("class type = {} (node name = {})", clazz, (Object)nodeName);
            if (clazz == null) {
                LOG.warn("Unable to determine object type for node name {}. Known elements include: {}", (Object)nodeName, this.m_knownElementClasses);
                return from;
            }
            DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
            LSSerializer serializer = lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            String str = serializer.writeToString(e);
            return JaxbUtils.unmarshal(clazz, str);
        }
        LOG.error("Unsure how to determine which class to use for unmarshaling object type {}", from.getClass());
        throw new IllegalArgumentException("Unsure how to determine which class to use for unmarshaling object type " + from.getClass());
    }

    public Object marshal(Object from) throws Exception {
        LOG.trace("marshal: from = ({}){}", from == null ? null : from.getClass(), from);
        if (from == null) {
            return null;
        }
        try {
            String s = JaxbUtils.marshal(from);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(s.getBytes()));
            Element node = doc.getDocumentElement();
            LOG.trace("marshal: node = {}", (Object)node);
            return node;
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unable to marshal object " + from, e);
            LOG.error("Unable to marshal object {}", from, (Object)ex);
            throw ex;
        }
    }

    public Class<?> getClassForElement(String nodeName) {
        Class<?> clazz = this.m_knownElementClasses.get(nodeName.toLowerCase());
        if (clazz != null) {
            return clazz;
        }
        return JaxbUtils.getClassForElement(nodeName);
    }
}

