/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.RrdLabelUtils;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.NodeIdAdapter;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SnmpInterfaceIdAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="snmpInterface")
@Entity
@Table(name="snmpInterface")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsSnmpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = 4688655131862954563L;
    private static final Logger LOG = LoggerFactory.getLogger(OnmsSnmpInterface.class);
    private Integer m_id;
    private String m_physAddr;
    private Integer m_ifIndex;
    private String m_ifDescr;
    private Integer m_ifType;
    private String m_ifName;
    private Long m_ifSpeed;
    private Integer m_ifAdminStatus;
    private Integer m_ifOperStatus;
    private String m_ifAlias;
    private Date m_lastCapsdPoll;
    private String m_collect = "N";
    private String m_poll;
    private Date m_lastSnmpPoll;
    private OnmsNode m_node;
    private Set<OnmsIpInterface> m_ipInterfaces = new HashSet<OnmsIpInterface>();
    private boolean m_hasFlows;

    public OnmsSnmpInterface(OnmsNode node, int ifIndex) {
        this(node, (Integer)ifIndex);
    }

    public OnmsSnmpInterface(OnmsNode node, Integer ifIndex) {
        this.m_ifIndex = ifIndex;
        this.m_node = node;
        if (node != null) {
            node.getSnmpInterfaces().add(this);
        }
    }

    public OnmsSnmpInterface() {
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @XmlAttribute(name="id")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="snmpPhysAddr", length=32)
    public String getPhysAddr() {
        return this.m_physAddr;
    }

    public void setPhysAddr(String snmpphysaddr) {
        this.m_physAddr = snmpphysaddr;
    }

    @Column(name="snmpIfIndex")
    @XmlAttribute(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer snmpifindex) {
        this.m_ifIndex = snmpifindex;
    }

    @Column(name="snmpIfDescr", length=256)
    public String getIfDescr() {
        return this.m_ifDescr;
    }

    public void setIfDescr(String snmpifdescr) {
        this.m_ifDescr = snmpifdescr;
    }

    @Column(name="snmpIfType")
    public Integer getIfType() {
        return this.m_ifType;
    }

    public void setIfType(Integer snmpiftype) {
        this.m_ifType = snmpiftype;
    }

    @Column(name="snmpIfName", length=32)
    public String getIfName() {
        return this.m_ifName;
    }

    public void setIfName(String snmpifname) {
        this.m_ifName = snmpifname;
    }

    @Column(name="snmpIfSpeed")
    public Long getIfSpeed() {
        return this.m_ifSpeed;
    }

    public void setIfSpeed(Long snmpifspeed) {
        this.m_ifSpeed = snmpifspeed;
    }

    @Column(name="snmpIfAdminStatus")
    public Integer getIfAdminStatus() {
        return this.m_ifAdminStatus;
    }

    public void setIfAdminStatus(Integer snmpifadminstatus) {
        this.m_ifAdminStatus = snmpifadminstatus;
    }

    @Column(name="snmpIfOperStatus")
    public Integer getIfOperStatus() {
        return this.m_ifOperStatus;
    }

    public void setIfOperStatus(Integer snmpifoperstatus) {
        this.m_ifOperStatus = snmpifoperstatus;
    }

    @Column(name="snmpIfAlias", length=256)
    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public void setIfAlias(String snmpifalias) {
        this.m_ifAlias = snmpifalias;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snmpLastCapsdPoll")
    public Date getLastCapsdPoll() {
        return this.m_lastCapsdPoll;
    }

    public void setLastCapsdPoll(Date lastCapsdPoll) {
        this.m_lastCapsdPoll = lastCapsdPoll;
    }

    @Column(name="snmpCollect")
    @XmlAttribute(name="collectFlag")
    public String getCollect() {
        return this.m_collect;
    }

    public void setCollect(String collect) {
        this.m_collect = collect;
    }

    @Column(name="snmpPoll")
    @XmlAttribute(name="pollFlag")
    public String getPoll() {
        return this.m_poll;
    }

    public void setPoll(String poll) {
        this.m_poll = poll;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snmpLastSnmpPoll")
    public Date getLastSnmpPoll() {
        return this.m_lastSnmpPoll;
    }

    public void setLastSnmpPoll(Date lastSnmpPoll) {
        this.m_lastSnmpPoll = lastSnmpPoll;
    }

    @Transient
    public boolean isCollectionUserSpecified() {
        return this.m_collect.startsWith("U");
    }

    @Transient
    @XmlAttribute(name="collect")
    public boolean isCollectionEnabled() {
        return "C".equals(this.m_collect) || "UC".equals(this.m_collect);
    }

    public void setCollectionEnabled(boolean shouldCollect) {
        this.setCollectionEnabled(shouldCollect, false);
    }

    public void setCollectionEnabled(boolean shouldCollect, boolean userSpecified) {
        if (userSpecified) {
            this.m_collect = shouldCollect ? "UC" : "UN";
        } else if (!this.m_collect.startsWith("U")) {
            this.m_collect = shouldCollect ? "C" : "N";
        }
    }

    @Transient
    @XmlAttribute(name="poll")
    public boolean isPollEnabled() {
        return "P".equals(this.m_poll);
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlJavaTypeAdapter(value=NodeIdAdapter.class)
    @JsonIgnore
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Transient
    @XmlTransient
    public Integer getNodeId() {
        if (this.m_node != null) {
            return this.m_node.getId();
        }
        return null;
    }

    @Column(name="hasFlows", nullable=false)
    @XmlAttribute(name="hasFlows")
    public boolean getHasFlows() {
        return this.m_hasFlows;
    }

    public void setHasFlows(boolean hasFlows) {
        this.m_hasFlows = hasFlows;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("snmpphysaddr", (Object)this.getPhysAddr()).add("snmpifindex", (Object)this.getIfIndex()).add("snmpifdescr", (Object)this.getIfDescr()).add("snmpiftype", (Object)this.getIfType()).add("snmpifname", (Object)this.getIfName()).add("snmpifspeed", (Object)this.getIfSpeed()).add("snmpifadminstatus", (Object)this.getIfAdminStatus()).add("snmpifoperstatus", (Object)this.getIfOperStatus()).add("snmpifalias", (Object)this.getIfAlias()).add("snmpCollect", (Object)this.getCollect()).add("snmpPoll", (Object)this.getPoll()).add("nodeId", this.getNode() == null ? null : this.getNode().getId()).add("lastCapsdPoll", (Object)this.getLastCapsdPoll()).add("lastSnmpPoll", (Object)this.getLastSnmpPoll()).add("hasFlows", this.getHasFlows()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitSnmpInterface(this);
        visitor.visitSnmpInterfaceComplete(this);
    }

    @OneToMany(mappedBy="snmpInterface", fetch=FetchType.LAZY)
    @XmlJavaTypeAdapter(value=SnmpInterfaceIdAdapter.class)
    @JsonIgnore
    public Set<OnmsIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public void setIpInterfaces(Set<OnmsIpInterface> ipInterfaces) {
        this.m_ipInterfaces = ipInterfaces;
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public OnmsIpInterface getPrimaryIpInterface() {
        return this.getNode().getPrimaryInterface();
    }

    public String computePhysAddrForRRD() {
        String physAddrForRRD = null;
        if (this.getPhysAddr() != null) {
            String parsedPhysAddr = AlphaNumeric.parseAndTrim((String)this.getPhysAddr());
            if (parsedPhysAddr.length() == 12) {
                physAddrForRRD = parsedPhysAddr;
            } else {
                LOG.debug("physAddrForRRD: physical address len is NOT 12, physAddr={}", (Object)parsedPhysAddr);
            }
        }
        LOG.debug("computed physAddr for {} to be {}", (Object)this, physAddrForRRD);
        return physAddrForRRD;
    }

    public String computeNameForRRD() {
        String firstChoice = RrdLabelUtils.PREFER_IFDESCR ? this.getIfDescr() : this.getIfName();
        String secondChoice = RrdLabelUtils.PREFER_IFDESCR ? this.getIfName() : this.getIfDescr();
        String label = null;
        if (firstChoice != null) {
            label = RrdLabelUtils.DONT_SANITIZE_IFNAME ? firstChoice : AlphaNumeric.parseAndReplace((String)firstChoice, (char)'_');
        } else if (secondChoice != null) {
            label = RrdLabelUtils.DONT_SANITIZE_IFNAME ? secondChoice : AlphaNumeric.parseAndReplace((String)secondChoice, (char)'_');
        } else {
            LOG.info("Interface ({}) has no ifName and no ifDescr...setting to label to 'no_ifLabel'.", (Object)this);
            label = "no_ifLabel";
        }
        return label;
    }

    public String computeLabelForRRD() {
        return RrdLabelUtils.computeLabelForRRD((String)this.getIfName(), (String)this.getIfDescr(), (String)this.getPhysAddr());
    }

    public void addIpInterface(OnmsIpInterface iface) {
        iface.setSnmpInterface(this);
        this.m_ipInterfaces.add(iface);
    }

    public void mergeSnmpInterfaceAttributes(OnmsSnmpInterface scannedSnmpIface) {
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfAdminStatus(), this.getIfAdminStatus())) {
            this.setIfAdminStatus(scannedSnmpIface.getIfAdminStatus());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfAlias(), this.getIfAlias())) {
            this.setIfAlias(scannedSnmpIface.getIfAlias());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfDescr(), this.getIfDescr())) {
            this.setIfDescr(scannedSnmpIface.getIfDescr());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfName(), this.getIfName())) {
            this.setIfName(scannedSnmpIface.getIfName());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfOperStatus(), this.getIfOperStatus())) {
            this.setIfOperStatus(scannedSnmpIface.getIfOperStatus());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfSpeed(), this.getIfSpeed())) {
            this.setIfSpeed(scannedSnmpIface.getIfSpeed());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfType(), this.getIfType())) {
            this.setIfType(scannedSnmpIface.getIfType());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getPhysAddr(), this.getPhysAddr())) {
            this.setPhysAddr(scannedSnmpIface.getPhysAddr());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getLastCapsdPoll(), this.getLastCapsdPoll())) {
            this.setLastCapsdPoll(scannedSnmpIface.getLastCapsdPoll());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getPoll(), this.getPoll())) {
            this.setPoll(scannedSnmpIface.getPoll());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getLastSnmpPoll(), this.getLastSnmpPoll())) {
            this.setLastSnmpPoll(scannedSnmpIface.getLastSnmpPoll());
        }
        if (scannedSnmpIface.isCollectionUserSpecified() || !this.isCollectionUserSpecified()) {
            this.setCollectionEnabled(scannedSnmpIface.isCollectionEnabled(), scannedSnmpIface.isCollectionUserSpecified());
        }
    }
}

