/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import org.linkedin.util.io.resource.FilteredResource;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.AbstractResourceProvider;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;

public class FilteredResourceProvider
extends AbstractResourceProvider {
    private final InternalResourceProvider _resourceProvider;

    public FilteredResourceProvider(InternalResourceProvider resourceProvider) {
        this._resourceProvider = resourceProvider;
    }

    public FilteredResourceProvider(Resource resource) {
        this((InternalResourceProvider)((InternalResource)resource).getResourceProvider());
    }

    public InternalResourceProvider getFilteredResourceProvider() {
        return this._resourceProvider;
    }

    @Override
    public InternalResource doBuildResource(String path) {
        return this.doBuildResource(this._resourceProvider.doBuildResource(path));
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        return this.doCreateResourceProvider(this._resourceProvider.doCreateResourceProvider(rootPath));
    }

    protected InternalResourceProvider doCreateResourceProvider(InternalResourceProvider resourceProvider) {
        return new FilteredResourceProvider(resourceProvider);
    }

    @Override
    public boolean doList(String path, final ResourceFilter filter) {
        ResourceFilter newFilter = new ResourceFilter(){

            @Override
            public boolean accept(Resource resource) {
                return filter.accept(FilteredResourceProvider.this.doBuildResource(resource));
            }
        };
        return this._resourceProvider.doList(path, newFilter);
    }

    protected InternalResource doBuildResource(Resource filteredResource) {
        return new FilteredResource(this, filteredResource.getPath(), filteredResource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredResourceProvider that = (FilteredResourceProvider)o;
        return this._resourceProvider.equals(that._resourceProvider);
    }

    public int hashCode() {
        return this._resourceProvider.hashCode();
    }
}

