/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Percentage;

public class Processor
implements CounterData {
    public final Percentage cpu_5s;
    public final Percentage cpu_1m;
    public final Percentage cpu_5m;
    public final UnsignedLong total_memory;
    public final UnsignedLong free_memory;

    public Processor(ByteBuf buffer) throws InvalidPacketException {
        this.cpu_5s = new Percentage(buffer);
        this.cpu_1m = new Percentage(buffer);
        this.cpu_5m = new Percentage(buffer);
        this.total_memory = BufferUtils.uint64((ByteBuf)buffer);
        this.free_memory = BufferUtils.uint64((ByteBuf)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpu_5s", (Object)this.cpu_5s).add("cpu_1m", (Object)this.cpu_1m).add("cpu_5m", (Object)this.cpu_5m).add("total_memory", (Object)this.total_memory).add("free_memory", (Object)this.free_memory).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("cpu_5s");
        this.cpu_5s.writeBson(bsonWriter, enr);
        bsonWriter.writeName("cpu_1m");
        this.cpu_1m.writeBson(bsonWriter, enr);
        bsonWriter.writeName("cpu_5m");
        this.cpu_5m.writeBson(bsonWriter, enr);
        bsonWriter.writeInt64("total_memory", this.total_memory.longValue());
        bsonWriter.writeInt64("free_memory", this.free_memory.longValue());
        bsonWriter.writeEndDocument();
    }
}

