/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

public class Order {
    private final String m_attribute;
    private final boolean m_ascending;

    public Order(String attribute, boolean ascending) {
        this.m_attribute = attribute;
        this.m_ascending = ascending;
    }

    public void visit(OrderVisitor visitor) {
        visitor.visitAttribute(this.getAttribute());
        visitor.visitAscending(this.asc());
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public boolean asc() {
        return this.m_ascending;
    }

    public boolean desc() {
        return !this.m_ascending;
    }

    public static Order asc(String attribute) {
        return new Order(attribute, true);
    }

    public static Order desc(String attribute) {
        return new Order(attribute, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_attribute == null ? 0 : this.m_attribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return !(this.m_attribute == null ? other.m_attribute != null : !this.m_attribute.equals(other.m_attribute));
    }

    public String toString() {
        return "Order [attribute=" + this.m_attribute + ", ascending=" + this.m_ascending + "]";
    }

    public static interface OrderVisitor {
        public void visitAttribute(String var1);

        public void visitAscending(boolean var1);
    }
}

