/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.config.api.ConfigReloadContainer;
import org.opennms.core.xml.AbstractMergingJaxbConfigDao;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.ResourceTypes;

public class DefaultResourceTypesDao
extends AbstractMergingJaxbConfigDao<ResourceTypes, ResourceTypes>
implements ResourceTypesDao {
    private ConfigReloadContainer<ResourceTypes> m_extContainer;

    public DefaultResourceTypesDao() {
        super(ResourceTypes.class, "Resource Type Definitions", Paths.get("etc", "resource-types.d"));
        this.initExtensions();
    }

    public Map<String, ResourceType> getResourceTypes() {
        ResourceTypes resourceTypesFromContainer;
        HashMap<String, ResourceType> resourceTypesByName = new HashMap<String, ResourceType>();
        resourceTypesByName.putAll(DataCollectionConfigFactory.getInstance().getConfiguredResourceTypes());
        ResourceTypes configuredResourceTypes = (ResourceTypes)this.getObject();
        if (configuredResourceTypes != null) {
            configuredResourceTypes.getResourceTypes().stream().forEach(r -> resourceTypesByName.put(r.getName(), (ResourceType)r));
        }
        if ((resourceTypesFromContainer = (ResourceTypes)this.m_extContainer.getObject()) != null) {
            resourceTypesFromContainer.getResourceTypes().stream().forEach(r -> resourceTypesByName.put(r.getName(), (ResourceType)r));
        }
        return resourceTypesByName;
    }

    public ResourceType getResourceTypeByName(String name) {
        return this.getResourceTypes().get(name);
    }

    public ResourceTypes translateConfig(ResourceTypes config) {
        return config;
    }

    public ResourceTypes mergeConfigs(ResourceTypes source, ResourceTypes target) {
        if (target == null) {
            target = new ResourceTypes();
        }
        if (source != null) {
            target.getResourceTypes().addAll(source.getResourceTypes());
        }
        return target;
    }

    public Date getLastUpdate() {
        Date lastUpdateOfResourceTypes;
        Date lastUpdateOfDcConfig = DataCollectionConfigFactory.getInstance().getLastUpdate();
        if (lastUpdateOfDcConfig.after(lastUpdateOfResourceTypes = super.getLastUpdate())) {
            return lastUpdateOfDcConfig;
        }
        return lastUpdateOfResourceTypes;
    }

    private void initExtensions() {
        this.m_extContainer = new ConfigReloadContainer.Builder(ResourceTypes.class).withFolder((accumulator, next) -> accumulator.getResourceTypes().addAll(next.getResourceTypes())).build();
    }
}

