/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers;

import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet4Header;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet6Header;

public class EthernetHeader {
    public final Integer vlan;
    public final Inet4Header inet4Header;
    public final Inet6Header inet6Header;
    public final byte[] rawHeader;

    public EthernetHeader(ByteBuffer buffer) throws InvalidPacketException {
        BufferUtils.skip((ByteBuffer)buffer, (int)6);
        BufferUtils.skip((ByteBuffer)buffer, (int)6);
        int type = BufferUtils.uint16((ByteBuffer)buffer);
        if (type == 33024) {
            this.vlan = BufferUtils.uint16((ByteBuffer)buffer) & 0xFFF;
            type = BufferUtils.uint16((ByteBuffer)buffer);
        } else {
            this.vlan = null;
        }
        switch (type) {
            case 2048: {
                this.inet4Header = new Inet4Header(buffer);
                this.inet6Header = null;
                this.rawHeader = null;
                break;
            }
            case 34525: {
                this.inet4Header = null;
                this.inet6Header = new Inet6Header(buffer);
                this.rawHeader = null;
                break;
            }
            default: {
                this.inet4Header = null;
                this.inet6Header = null;
                this.rawHeader = BufferUtils.bytes((ByteBuffer)buffer, (int)buffer.remaining());
            }
        }
    }

    public EthernetHeader(Integer vlan, Inet4Header inet4Header, Inet6Header inet6Header, byte[] rawHeader) {
        this.vlan = vlan;
        this.inet4Header = inet4Header;
        this.inet6Header = inet6Header;
        this.rawHeader = rawHeader;
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        if (this.vlan != null) {
            bsonWriter.writeInt64("vlan", (long)this.vlan.intValue());
        }
        bsonWriter.writeEndDocument();
    }
}

