/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.MemcacheCmd;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.MemcacheProtocol;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.MemcacheStatus;

public class MemcacheOperation
implements CounterData {
    public final MemcacheProtocol protocol;
    public final MemcacheCmd cmd;
    public final AsciiString key;
    public final long nkeys;
    public final long value_bytes;
    public final long uS;
    public final MemcacheStatus status;

    public MemcacheOperation(ByteBuffer buffer) throws InvalidPacketException {
        this.protocol = MemcacheProtocol.from(buffer);
        this.cmd = MemcacheCmd.from(buffer);
        this.key = new AsciiString(buffer);
        this.nkeys = BufferUtils.uint32((ByteBuffer)buffer);
        this.value_bytes = BufferUtils.uint32((ByteBuffer)buffer);
        this.uS = BufferUtils.uint32((ByteBuffer)buffer);
        this.status = MemcacheStatus.from(buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", (Object)this.protocol).add("cmd", (Object)this.cmd).add("key", (Object)this.key).add("nkeys", this.nkeys).add("value_bytes", this.value_bytes).add("uS", this.uS).add("status", (Object)this.status).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("protocol");
        this.protocol.writeBson(bsonWriter, enr);
        bsonWriter.writeName("cmd");
        this.cmd.writeBson(bsonWriter, enr);
        bsonWriter.writeString("key", this.key.value);
        bsonWriter.writeInt64("nkeys", this.nkeys);
        bsonWriter.writeInt64("value_bytes", this.value_bytes);
        bsonWriter.writeInt64("uS", this.uS);
        bsonWriter.writeName("status");
        this.status.writeBson(bsonWriter, enr);
        bsonWriter.writeEndDocument();
    }
}

