/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;

public class ExtendedSwitch
implements FlowData {
    public final long src_vlan;
    public final long src_priority;
    public final long dst_vlan;
    public final long dst_priority;

    public ExtendedSwitch(ByteBuffer buffer) throws InvalidPacketException {
        this.src_vlan = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_priority = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_vlan = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_priority = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public ExtendedSwitch(long src_vlan, long src_priority, long dst_vlan, long dst_priority) {
        this.src_vlan = src_vlan;
        this.src_priority = src_priority;
        this.dst_vlan = dst_vlan;
        this.dst_priority = dst_priority;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src_vlan", this.src_vlan).add("src_priority", this.src_priority).add("dst_vlan", this.dst_vlan).add("dst_priority", this.dst_priority).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("src_vlan", this.src_vlan);
        bsonWriter.writeInt64("src_priority", this.src_priority);
        bsonWriter.writeInt64("dst_vlan", this.dst_vlan);
        bsonWriter.writeInt64("dst_priority", this.dst_priority);
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

