/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.OffHeapStore;
import org.opennms.core.ipc.sink.api.OffHeapQueue;
import org.opennms.core.ipc.sink.api.WriteFailedException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2OffHeapStore
implements OffHeapQueue {
    private static final Logger LOG = LoggerFactory.getLogger(H2OffHeapStore.class);
    private static final String OFFHEAP_CONFIG = "org.opennms.core.ipc.sink.offheap";
    private static final String OFFHEAP_SIZE = "offHeapSize";
    private static final String DEFAULT_OFFHEAP_SIZE = "10MB";
    private static final long DEFAULT_WAIT_FOR_POLL = 1000L;
    private JmxReporter reporter = null;
    private MetricRegistry offheapMetrics = new MetricRegistry();
    private MVStore store;
    private long maxSizeInBytes;
    private final ConfigurationAdmin configAdmin;
    private Map<String, MVMap<String, byte[]>> mvMapRegistry = new ConcurrentHashMap<String, MVMap<String, byte[]>>();
    private Map<String, BlockingQueue<String>> queueMap = new ConcurrentHashMap<String, BlockingQueue<String>>();

    public H2OffHeapStore(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void init() throws IOException {
        this.store = new MVStore.Builder().fileStore((FileStore)new OffHeapStore()).open();
        Dictionary properties = this.configAdmin.getConfiguration(OFFHEAP_CONFIG).getProperties();
        if (properties != null && properties.get(OFFHEAP_SIZE) != null && properties.get(OFFHEAP_SIZE) instanceof String) {
            this.maxSizeInBytes = this.convertByteSizes((String)properties.get(OFFHEAP_SIZE));
        }
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.offheapMetrics).inDomain(this.getClass().getPackage().getName()).build();
        this.offheapMetrics.register(MetricRegistry.name((String)OFFHEAP_SIZE, (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return H2OffHeapStore.this.getSize();
            }
        });
        this.reporter.start();
        LOG.info("initializing H2 OffHeapStore with max size : {} ", (Object)this.maxSizeInBytes);
    }

    public boolean writeMessage(byte[] message, String moduleName, String key) throws WriteFailedException {
        long storeSize = this.store.getFileStore().size();
        if (message == null || Strings.isNullOrEmpty((String)moduleName)) {
            throw new WriteFailedException("Invalid message");
        }
        if (storeSize + (long)message.length > this.maxSizeInBytes) {
            throw new WriteFailedException("Offheap storage exhausted, size = " + this.maxSizeInBytes);
        }
        MVMap mvMap = this.mvMapRegistry.get(moduleName);
        if (mvMap == null) {
            mvMap = this.store.openMap(moduleName);
            this.mvMapRegistry.put(moduleName, (MVMap<String, byte[]>)mvMap);
            this.queueMap.put(moduleName, new LinkedBlockingQueue());
            LOG.info("initialized mvMap for module : {} ", (Object)moduleName);
        }
        mvMap.put((Object)key, (Object)message);
        BlockingQueue<String> keys = this.queueMap.get(moduleName);
        keys.add(key);
        return true;
    }

    public AbstractMap.SimpleImmutableEntry<String, byte[]> readNextMessage(String moduleName) throws InterruptedException {
        BlockingQueue<String> queueOfKeys = this.queueMap.get(moduleName);
        if (queueOfKeys == null) {
            LOG.warn("No data was ever written for this module {}", (Object)moduleName);
            return null;
        }
        String uuid = queueOfKeys.poll(1000L, TimeUnit.MILLISECONDS);
        if (uuid == null) {
            return null;
        }
        MVMap<String, byte[]> mvMap = this.mvMapRegistry.get(moduleName);
        if (mvMap != null) {
            byte[] value = (byte[])mvMap.get((Object)uuid);
            mvMap.remove((Object)uuid);
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(uuid, value);
        }
        return null;
    }

    public void destroy() {
        this.mvMapRegistry.forEach((module, mvMap) -> mvMap.clear());
        LOG.info("closing H2OffHeapStore, size = {} ", (Object)this.getSize());
        this.store.getFileStore().close();
        this.store.close();
        this.reporter.stop();
    }

    private long convertByteSizes(String size) {
        String suffix = size.substring(size.length() - 2, size.length());
        double value = 0.0;
        long bytes = 0L;
        try {
            value = Double.parseDouble(size.substring(0, size.length() - 2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (suffix) {
            case "KB": {
                bytes = (long)(value * 1024.0);
                break;
            }
            case "MB": {
                bytes = (long)(value * 1024.0 * 1024.0);
                break;
            }
            case "GB": {
                bytes = (long)(value * 1024.0 * 1024.0 * 1024.0);
            }
        }
        if (bytes == 0L) {
            LOG.error("Provided offheap size '{}' is invalid, using default as {}", (Object)size, (Object)DEFAULT_OFFHEAP_SIZE);
            return this.convertByteSizes(DEFAULT_OFFHEAP_SIZE);
        }
        return bytes;
    }

    public long getSize() {
        return this.store.getFileStore().size();
    }

    public int getNumOfMessages(String moduleName) {
        BlockingQueue<String> queue = this.queueMap.get(moduleName);
        if (queue != null) {
            return queue.size();
        }
        return 0;
    }
}

