/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LocationUtils;
import org.opennms.netmgt.config.snmp.AbstractSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.SnmpProfile;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSnmpConfigVisitor
extends AbstractSnmpConfigVisitor
implements SnmpConfigVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AddressSnmpConfigVisitor.class);
    private static final ByteArrayComparator BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();
    private final InetAddress m_address;
    private final String m_location;
    private SnmpConfig m_currentConfig;
    private Definition m_currentDefinition;
    private String m_currentLocation;
    private Definition m_matchedDefinitionAtDefaultLocation;
    private Definition m_matchedDefinitionAtGivenLocation;
    private boolean m_isMatchingDefault = true;
    private Definition m_generatedDefinition = null;
    private SnmpProfile m_snmpProfile;

    public AddressSnmpConfigVisitor(InetAddress addr) {
        this(addr, null);
    }

    public AddressSnmpConfigVisitor(InetAddress addr, String location) {
        this.m_address = addr;
        this.m_location = LocationUtils.getEffectiveLocationName((String)location);
    }

    @Override
    public void visitSnmpConfig(SnmpConfig config) {
        this.m_currentConfig = config;
    }

    @Override
    public void visitDefinition(Definition definition) {
        this.m_currentDefinition = definition;
        this.m_currentLocation = LocationUtils.getEffectiveLocationName((String)definition.getLocation());
    }

    private void handleMatch() {
        if (LocationUtils.isDefaultLocationName((String)this.m_currentLocation)) {
            this.m_matchedDefinitionAtDefaultLocation = this.m_currentDefinition;
        }
        if (this.m_location.equals(this.m_currentLocation)) {
            this.m_matchedDefinitionAtGivenLocation = this.m_currentDefinition;
        }
    }

    private Definition getBestMatch() {
        if (this.m_matchedDefinitionAtGivenLocation != null) {
            return this.m_matchedDefinitionAtGivenLocation;
        }
        return this.m_matchedDefinitionAtDefaultLocation;
    }

    private boolean shouldTryToMatch() {
        if (LocationUtils.isDefaultLocationName((String)this.m_currentLocation)) {
            return this.m_matchedDefinitionAtDefaultLocation == null;
        }
        if (this.m_location.equals(this.m_currentLocation)) {
            return this.m_matchedDefinitionAtGivenLocation == null;
        }
        return false;
    }

    @Override
    public void visitSpecifics(List<String> specifics) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (String saddr : specifics) {
            try {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (addr == null || !addr.equals(this.m_address)) continue;
                this.handleMatch();
                return;
            }
            catch (IllegalArgumentException e) {
                LOG.info("Error while reading SNMP config <specific> tag: {}", (Object)saddr, (Object)e);
            }
        }
    }

    @Override
    public void visitRanges(List<Range> ranges) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (Range range : ranges) {
            boolean inRange;
            byte[] end;
            byte[] addr = this.m_address.getAddress();
            byte[] begin = InetAddressUtils.toIpAddrBytes((String)range.getBegin());
            if (BYTE_ARRAY_COMPARATOR.compare(begin, end = InetAddressUtils.toIpAddrBytes((String)range.getEnd())) <= 0) {
                inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])begin, (byte[])end);
            } else {
                LOG.warn("{} has an 'end' that is earlier than its 'beginning'!", (Object)range);
                inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])end, (byte[])begin);
            }
            if (!inRange) continue;
            this.handleMatch();
            return;
        }
    }

    @Override
    public void visitIpMatches(List<String> ipMatches) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (String ipMatch : ipMatches) {
            if (!IPLike.matches((InetAddress)this.m_address, (String)ipMatch)) continue;
            this.handleMatch();
            return;
        }
    }

    @Override
    public void visitDefinitionFinished() {
        this.m_currentDefinition = null;
    }

    @Override
    public void visitSnmpConfigFinished() {
        Configuration sourceConfig;
        if (this.getBestMatch() != null) {
            sourceConfig = this.getBestMatch();
            this.m_isMatchingDefault = false;
        } else {
            sourceConfig = this.m_currentConfig;
        }
        this.m_generatedDefinition = this.createDefinitionFromConfig(sourceConfig);
    }

    private Definition createDefinitionFromConfig(Configuration sourceConfig) {
        Definition definition = new Definition();
        if (sourceConfig.getProxyHost() != null) {
            definition.setProxyHost(sourceConfig.getProxyHost());
        } else {
            definition.setProxyHost(this.m_currentConfig.getProxyHost());
        }
        if (sourceConfig.hasMaxVarsPerPdu()) {
            definition.setMaxVarsPerPdu(sourceConfig.getMaxVarsPerPdu());
        } else if (this.m_currentConfig.hasMaxVarsPerPdu()) {
            definition.setMaxVarsPerPdu(this.m_currentConfig.getMaxVarsPerPdu());
        } else {
            definition.setMaxVarsPerPdu(10);
        }
        if (sourceConfig.hasMaxRepetitions()) {
            definition.setMaxRepetitions(sourceConfig.getMaxRepetitions());
        } else if (this.m_currentConfig.hasMaxRepetitions()) {
            definition.setMaxRepetitions(this.m_currentConfig.getMaxRepetitions());
        } else {
            definition.setMaxRepetitions(2);
        }
        if (sourceConfig.hasMaxRequestSize()) {
            definition.setMaxRequestSize(sourceConfig.getMaxRequestSize());
        } else if (this.m_currentConfig.hasMaxRequestSize()) {
            definition.setMaxRequestSize(this.m_currentConfig.getMaxRequestSize());
        } else {
            definition.setMaxRequestSize(65535);
        }
        if (sourceConfig.getSecurityName() != null) {
            definition.setSecurityName(sourceConfig.getSecurityName());
        } else if (this.m_currentConfig.getSecurityName() != null) {
            definition.setSecurityName(this.m_currentConfig.getSecurityName());
        } else {
            definition.setSecurityName("opennmsUser");
        }
        if (sourceConfig.getAuthPassphrase() != null) {
            definition.setAuthPassphrase(sourceConfig.getAuthPassphrase());
        } else if (this.m_currentConfig.getAuthPassphrase() != null) {
            definition.setAuthPassphrase(this.m_currentConfig.getAuthPassphrase());
        }
        if (sourceConfig.getAuthProtocol() != null) {
            definition.setAuthProtocol(sourceConfig.getAuthProtocol());
        } else if (this.m_currentConfig.getAuthProtocol() != null) {
            definition.setAuthProtocol(this.m_currentConfig.getAuthProtocol());
        } else {
            definition.setAuthProtocol("MD5");
        }
        if (sourceConfig.getEngineId() != null) {
            definition.setEngineId(sourceConfig.getEngineId());
        } else if (this.m_currentConfig.getEngineId() != null) {
            definition.setEngineId(this.m_currentConfig.getEngineId());
        } else {
            definition.setEngineId(SnmpConfiguration.DEFAULT_ENGINE_ID);
        }
        if (sourceConfig.getContextEngineId() != null) {
            definition.setContextEngineId(sourceConfig.getContextEngineId());
        } else if (this.m_currentConfig.getContextEngineId() != null) {
            definition.setContextEngineId(this.m_currentConfig.getContextEngineId());
        } else {
            definition.setContextEngineId(SnmpConfiguration.DEFAULT_CONTEXT_ENGINE_ID);
        }
        if (sourceConfig.getContextName() != null) {
            definition.setContextName(sourceConfig.getContextName());
        } else if (this.m_currentConfig.getContextName() != null) {
            definition.setContextName(this.m_currentConfig.getContextName());
        } else {
            definition.setContextName(SnmpConfiguration.DEFAULT_CONTEXT_NAME);
        }
        if (sourceConfig.getPrivacyPassphrase() != null) {
            definition.setPrivacyPassphrase(sourceConfig.getPrivacyPassphrase());
        } else if (this.m_currentConfig.getPrivacyPassphrase() != null) {
            definition.setPrivacyPassphrase(this.m_currentConfig.getPrivacyPassphrase());
        }
        if (sourceConfig.getPrivacyProtocol() != null) {
            definition.setPrivacyProtocol(sourceConfig.getPrivacyProtocol());
        } else if (this.m_currentConfig.getPrivacyProtocol() != null) {
            definition.setPrivacyProtocol(this.m_currentConfig.getPrivacyProtocol());
        } else {
            definition.setPrivacyProtocol("DES");
        }
        if (sourceConfig.getEnterpriseId() != null) {
            definition.setEnterpriseId(sourceConfig.getEnterpriseId());
        } else {
            definition.setEnterpriseId(this.m_currentConfig.getEnterpriseId());
        }
        if (sourceConfig.getVersion() != null) {
            definition.setVersion(sourceConfig.getVersion());
        } else if (this.m_currentConfig.getVersion() != null) {
            definition.setVersion(this.m_currentConfig.getVersion());
        } else {
            definition.setVersion(SnmpConfiguration.versionToString((int)1));
        }
        if (sourceConfig.getWriteCommunity() != null) {
            definition.setWriteCommunity(sourceConfig.getWriteCommunity());
        } else if (this.m_currentConfig.getWriteCommunity() != null) {
            definition.setWriteCommunity(this.m_currentConfig.getWriteCommunity());
        } else {
            definition.setWriteCommunity("private");
        }
        if (sourceConfig.getReadCommunity() != null) {
            definition.setReadCommunity(sourceConfig.getReadCommunity());
        } else if (this.m_currentConfig.getReadCommunity() != null) {
            definition.setReadCommunity(this.m_currentConfig.getReadCommunity());
        } else {
            definition.setReadCommunity("public");
        }
        if (sourceConfig.hasTimeout()) {
            definition.setTimeout(sourceConfig.getTimeout());
        } else if (this.m_currentConfig.hasTimeout()) {
            definition.setTimeout(this.m_currentConfig.getTimeout());
        } else {
            definition.setTimeout(3000);
        }
        if (sourceConfig.hasRetry()) {
            definition.setRetry(sourceConfig.getRetry());
        } else if (this.m_currentConfig.hasRetry()) {
            definition.setRetry(this.m_currentConfig.getRetry());
        } else {
            definition.setRetry(1);
        }
        if (sourceConfig.hasPort()) {
            definition.setPort(sourceConfig.getPort());
        } else if (this.m_currentConfig.hasPort()) {
            definition.setPort(this.m_currentConfig.getPort());
        } else {
            definition.setPort(161);
        }
        if (definition.getAuthPassphrase() == null) {
            definition.setAuthProtocol(null);
        }
        if (definition.getPrivacyPassphrase() == null) {
            definition.setPrivacyProtocol(null);
        }
        if (sourceConfig.hasSecurityLevel()) {
            definition.setSecurityLevel(sourceConfig.getSecurityLevel());
        } else if (this.m_currentConfig.hasSecurityLevel()) {
            definition.setSecurityLevel(this.m_currentConfig.getSecurityLevel());
        } else {
            int securityLevel = 1;
            securityLevel = this.isBlank(definition.getAuthPassphrase()) ? 1 : (this.isBlank(definition.getPrivacyPassphrase()) ? 2 : 3);
            definition.setSecurityLevel(securityLevel);
        }
        if (sourceConfig.hasTTL()) {
            definition.setTTL(sourceConfig.getTTL());
        } else if (this.m_currentConfig.hasTTL()) {
            definition.setTTL(this.m_currentConfig.getTTL());
        }
        return definition;
    }

    @Override
    public void visitSnmpProfile(SnmpProfile snmpProfile) {
        this.m_snmpProfile = snmpProfile;
    }

    @Override
    public void visitSnmpProfileFinished() {
        this.m_generatedDefinition = this.createDefinitionFromConfig(this.m_snmpProfile);
    }

    public Definition getDefinition() {
        return this.m_generatedDefinition;
    }

    public boolean isMatchingDefaultConfig() {
        return this.m_isMatchingDefault;
    }

    private boolean isBlank(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }
}

