/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd.api;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.syslogd.api.SyslogMessageDTO;

@XmlRootElement(name="syslog-message-log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogMessageLogDTO
implements Message {
    @XmlAttribute(name="source-address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress sourceAddress;
    @XmlAttribute(name="source-port")
    private int sourcePort;
    @XmlAttribute(name="system-id")
    private String systemId;
    @XmlAttribute(name="location")
    private String location;
    @XmlElement(name="messages")
    private List<SyslogMessageDTO> messages;

    public SyslogMessageLogDTO() {
        this.messages = new ArrayList<SyslogMessageDTO>(0);
    }

    public SyslogMessageLogDTO(String location, String systemId, InetSocketAddress source) {
        this(location, systemId, source, new ArrayList<SyslogMessageDTO>(0));
    }

    public SyslogMessageLogDTO(String location, String systemId, InetSocketAddress source, List<SyslogMessageDTO> messages) {
        this.location = location;
        this.systemId = systemId;
        this.sourceAddress = source.getAddress();
        this.sourcePort = source.getPort();
        this.messages = messages;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(InetAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<SyslogMessageDTO> getMessages() {
        return this.messages;
    }

    public void setMessages(List<SyslogMessageDTO> messages) {
        this.messages = messages;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SyslogMessageLogDTO)) {
            return false;
        }
        SyslogMessageLogDTO castOther = (SyslogMessageLogDTO)other;
        return Objects.equals(this.sourceAddress, castOther.sourceAddress) && Objects.equals(this.sourcePort, castOther.sourcePort) && Objects.equals(this.systemId, castOther.systemId) && Objects.equals(this.location, castOther.location) && Objects.equals(this.messages, castOther.messages);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAddress, this.sourcePort, this.systemId, this.location, this.messages);
    }
}

