/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.IPHeader;

public class ErrorMessage
extends ICMPHeader {
    private IPHeader m_iphdr;
    private byte[] m_protoData;

    protected ErrorMessage(byte type, byte code) {
        super(type, code);
        this.m_iphdr = null;
        this.m_protoData = null;
    }

    public ErrorMessage(byte[] buf, int offset) {
        this.loadFromBuffer(buf, offset);
    }

    public final int loadFromBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 36) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP error message");
        }
        offset = super.loadFromBuffer(buf, offset);
        this.m_iphdr = new IPHeader(buf, offset);
        if (buf.length < offset + 16 + this.m_iphdr.getHeaderLength()) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP error message");
        }
        offset += this.m_iphdr.getHeaderLength();
        this.m_protoData = new byte[8];
        for (int x = 0; x < 8; ++x) {
            this.m_protoData[x] = buf[offset++];
        }
        return offset;
    }

    public final IPHeader getIPHeader() {
        return this.m_iphdr;
    }

    protected void setIPHeader(IPHeader hdr) {
        this.m_iphdr = hdr;
    }

    public final byte[] getProtocolData() {
        return this.m_protoData;
    }

    protected void setProtocolData(byte[] pd) {
        if (pd.length < 8) {
            throw new IndexOutOfBoundsException("Protocol data must be 8 bytes in length");
        }
        if (pd.length > 8) {
            throw new IllegalArgumentException("Protocol data cannot be more than 8 bytes in length");
        }
        this.m_protoData = pd;
    }
}

