/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FilesystemForeignSourceRepository
extends AbstractForeignSourceRepository
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemForeignSourceRepository.class);
    protected String m_requisitionPath;
    protected String m_foreignSourcePath;
    protected final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    protected final Lock m_readLock = this.m_globalLock.readLock();
    protected final Lock m_writeLock = this.m_globalLock.writeLock();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_requisitionPath, (String)"Requisition path must not be empty.");
        Assert.notNull((Object)this.m_foreignSourcePath, (String)"Foreign source path must not be empty.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.m_readLock.lock();
        try {
            TreeSet<String> fsNames = new TreeSet<String>();
            File directory = new File(this.m_foreignSourcePath);
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            if ((directory = new File(this.m_requisitionPath)).exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            TreeSet<String> treeSet = fsNames;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            int n = this.getForeignSources().size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_foreignSourcePath);
            File[] foreignSources = new TreeSet();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    foreignSources.add(RequisitionFileUtils.getForeignSourceFromFile(file));
                }
            }
            File[] fileArray = foreignSources;
            return fileArray;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = RequisitionFileUtils.encodeFileName(this.m_foreignSourcePath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                ForeignSource foreignSource = RequisitionFileUtils.getForeignSourceFromFile(inputFile);
                return foreignSource;
            }
            ForeignSource fs = this.getDefaultForeignSource();
            fs.setName(foreignSourceName);
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't save a null foreign source!");
        }
        LOG.debug("Writing foreign source {} to {}", (Object)foreignSource.getName(), (Object)this.m_foreignSourcePath);
        this.validate(foreignSource);
        this.m_writeLock.lock();
        try {
            if (foreignSource.getName().equals("default")) {
                this.putDefaultForeignSource(foreignSource);
                return;
            }
            File outputFile = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            FileOutputStream outputStream = null;
            OutputStreamWriter writer = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                JaxbUtils.marshal((Object)foreignSource, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public final void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_writeLock.lock();
        try {
            LOG.debug("Deleting foreign source {} from {} (if necessary)", (Object)foreignSource.getName(), (Object)this.m_foreignSourcePath);
            File fileToDelete = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            if (fileToDelete.exists() && !fileToDelete.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete foreign source file " + fileToDelete);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_requisitionPath);
            File[] requisitions = new TreeSet();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    try {
                        requisitions.add(RequisitionFileUtils.getRequisitionFromFile(file));
                    }
                    catch (ForeignSourceRepositoryException foreignSourceRepositoryException) {
                        // empty catch block
                    }
                }
            }
            File[] fileArray = requisitions;
            return fileArray;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = RequisitionFileUtils.encodeFileName(this.m_requisitionPath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                Requisition requisition = RequisitionFileUtils.getRequisitionFromFile(inputFile);
                return requisition;
            }
            Requisition requisition = null;
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public final Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource.getName());
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't save a null requisition!");
        }
        LOG.debug("Writing requisition {} to {}", (Object)requisition.getForeignSource(), (Object)this.m_requisitionPath);
        this.validate(requisition);
        this.m_writeLock.lock();
        try {
            File outputFile = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            OutputStreamWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                JaxbUtils.marshal((Object)requisition, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public final void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't delete a null requisition!");
        }
        this.m_writeLock.lock();
        try {
            LOG.debug("Deleting requisition {} from {} (if necessary)", (Object)requisition.getForeignSource(), (Object)this.m_requisitionPath);
            File fileToDelete = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            if (fileToDelete.exists()) {
                if (!fileToDelete.delete()) {
                    throw new ForeignSourceRepositoryException("Unable to delete requisition file " + fileToDelete);
                }
            } else {
                LOG.debug("File {} does not exist.", (Object)fileToDelete);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public final void setRequisitionPath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_requisitionPath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public final void setForeignSourcePath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_foreignSourcePath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Date getRequisitionDate(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource);
            if (requisition == null) {
                Date date = null;
                return date;
            }
            Date date = requisition.getDate();
            return date;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            URL uRL = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, foreignSource).toURI().toURL();
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public final void flush() throws ForeignSourceRepositoryException {
        LOG.debug("flush() called");
    }
}

