/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcExceptionHandler;
import org.opennms.core.rpc.api.RpcExceptionUtils;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.echo.EchoRequest;
import org.opennms.core.rpc.echo.EchoResponse;
import org.opennms.core.rpc.echo.EchoRpcModule;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Interpolator;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;

@Distributable(value={DistributionContext.DAEMON})
public class MinionRpcMonitor
extends AbstractServiceMonitor
implements RpcExceptionHandler<PollStatus> {
    private final Supplier<NodeDao> nodeDao = Suppliers.memoize(() -> (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class));
    private final Supplier<EntityScopeProvider> entityScopeProvider = Suppliers.memoize(() -> (EntityScopeProvider)BeanUtils.getBean((String)"daoContext", (String)"entityScopeProvider", EntityScopeProvider.class));
    private final Supplier<RpcClientFactory> rpcClientFactory = Suppliers.memoize(() -> (RpcClientFactory)BeanUtils.getBeanFactory((String)"daoContext").getFactory().getBean(RpcClientFactory.class));
    private static final int DEFAULT_MESSAGE_SIZE = 1024;
    private static final String MESSAGE_SIZE = "message-size";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        RpcClient client = ((RpcClientFactory)this.rpcClientFactory.get()).getClient((RpcModule)EchoRpcModule.INSTANCE);
        Map interpolatedAttributes = Interpolator.interpolateObjects(parameters, (Scope)new FallbackScope(new Scope[]{((EntityScopeProvider)this.entityScopeProvider.get()).getScopeForNode(Integer.valueOf(svc.getNodeId())), ((EntityScopeProvider)this.entityScopeProvider.get()).getScopeForInterface(Integer.valueOf(svc.getNodeId()), svc.getIpAddr()), ((EntityScopeProvider)this.entityScopeProvider.get()).getScopeForService(Integer.valueOf(svc.getNodeId()), svc.getAddress(), svc.getSvcName())}));
        Long ttlInMs = ParameterMap.getLongValue((String)"ttl", interpolatedAttributes.get("ttl"), null);
        int messageSize = ParameterMap.getIntValue((String)MESSAGE_SIZE, interpolatedAttributes.get(MESSAGE_SIZE), (Integer)1024);
        if (messageSize < 0) {
            messageSize = 0;
        }
        OnmsNode node = (OnmsNode)((NodeDao)this.nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()));
        EchoRequest request = new EchoRequest();
        request.setId(Long.valueOf(System.currentTimeMillis()));
        request.setMessage(Strings.repeat((String)"*", (int)messageSize));
        request.setLocation(node.getLocation().getLocationName());
        request.setSystemId(node.getForeignId());
        request.setTimeToLiveMs(ttlInMs);
        request.addTracingInfo("nodeId", String.valueOf(node.getId()));
        request.addTracingInfo("nodeLabel", node.getLabel());
        request.addTracingInfo("className", MinionRpcMonitor.class.getCanonicalName());
        request.addTracingInfo("ipAddress", InetAddressUtils.toIpAddrString((InetAddress)svc.getAddress()));
        try {
            EchoResponse response = (EchoResponse)client.execute((RpcRequest)request).get();
            Long responseTime = System.currentTimeMillis() - response.getId();
            return PollStatus.available((Double)responseTime.doubleValue());
        }
        catch (InterruptedException | ExecutionException t) {
            return (PollStatus)RpcExceptionUtils.handleException((Throwable)t, (RpcExceptionHandler)this);
        }
    }

    public String getEffectiveLocation(String location) {
        return "Default";
    }

    public PollStatus onInterrupted(Throwable t) {
        return PollStatus.unknown((String)"Interrupted.");
    }

    public PollStatus onTimedOut(Throwable t) {
        return PollStatus.unresponsive((String)"Request timed out.");
    }

    public PollStatus onRejected(Throwable t) {
        return PollStatus.unknown((String)"Rejected.");
    }

    public PollStatus onUnknown(Throwable t) {
        return PollStatus.unresponsive((String)("Failed with unknown exception: " + t.getMessage()));
    }
}

