/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTable;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.BridgeSimpleConnection;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DiscoveryBridgeTopology {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryBridgeTopology.class);
    private Map<Integer, BridgeForwardingTable> m_bridgeFtMapUpdate = new HashMap<Integer, BridgeForwardingTable>();
    private final BroadcastDomain m_domain;
    private Set<Integer> m_failed;
    private Set<Integer> m_parsed;

    public BroadcastDomain getDomain() {
        return this.m_domain;
    }

    public Set<Integer> getFailed() {
        return this.m_failed;
    }

    public Set<Integer> getParsed() {
        return this.m_parsed;
    }

    public void addUpdatedBFT(Integer bridgeid, Set<BridgeForwardingTableEntry> notYetParsedBFT) {
        if (this.m_domain.getBridge(bridgeid) == null) {
            Bridge.create(this.m_domain, bridgeid);
        }
        try {
            this.m_bridgeFtMapUpdate.put(bridgeid, BridgeForwardingTable.create(this.m_domain.getBridge(bridgeid), notYetParsedBFT));
        }
        catch (BridgeTopologyException e) {
            LOG.warn("calculate:  node[{}], {}, topology:\n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology(), e});
        }
    }

    public DiscoveryBridgeTopology(BroadcastDomain domain) {
        Assert.notNull((Object)domain);
        this.m_domain = domain;
    }

    public String getInfo() {
        StringBuffer info = new StringBuffer();
        info.append(this.getName());
        if (this.m_domain != null) {
            info.append(" domain nodes: ");
            info.append(this.m_domain.getBridgeNodesOnDomain());
        }
        if (this.m_bridgeFtMapUpdate != null) {
            info.append(", updated bft nodes: ");
            info.append(this.m_bridgeFtMapUpdate.keySet());
        }
        if (this.m_parsed != null) {
            info.append(", parsed bft nodes: ");
            info.append(this.m_parsed);
        }
        if (this.m_failed != null) {
            info.append(", failed bft nodes: ");
            info.append(this.m_failed);
        }
        return info.toString();
    }

    public String getName() {
        return "DiscoveryBridgeTopology";
    }

    private Bridge calcRootBridge() {
        int size = 0;
        Bridge elected = null;
        for (Integer bridgeid : this.m_bridgeFtMapUpdate.keySet()) {
            Bridge bridge = this.m_domain.getBridge(bridgeid);
            LOG.debug("calculate: bridge:[{}] bft size \"{}\" in topology", (Object)bridge.getNodeId(), (Object)this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize());
            if (size >= this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize()) continue;
            elected = bridge;
            size = this.m_bridgeFtMapUpdate.get(bridgeid).getBftSize();
        }
        if (elected != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: bridge:[{}] 'elected' root with max bft size \"{}\" in topology", (Object)elected.getNodeId(), (Object)size);
            }
        } else {
            elected = this.m_domain.getBridges().iterator().next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: bridge:[{}] 'elected' first bridge in topology", (Object)elected.getNodeId());
            }
        }
        return elected;
    }

    private Bridge electRootBridge() throws BridgeTopologyException {
        Bridge electedRoot = BroadcastDomain.electRootBridge(this.m_domain);
        Bridge rootBridge = this.m_domain.getRootBridge();
        if (electedRoot == null) {
            electedRoot = rootBridge != null ? rootBridge : this.calcRootBridge();
        }
        if (electedRoot.getNodeId() == null) {
            throw new BridgeTopologyException("elected Root bridge id cannot be null", electedRoot);
        }
        return electedRoot;
    }

    private void root(BridgeForwardingTable rootBft, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul) throws BridgeTopologyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: bridge:[{}] elected has updated bft", (Object)rootBft.getNodeId());
        }
        if (this.m_domain.getSharedSegments().isEmpty()) {
            rootBft.getBridge().setRootBridge();
            rootBft.getPorttomac().stream().forEach(ts -> SharedSegment.createAndAddToBroadcastDomain(this.m_domain, ts));
            LOG.debug("calculate: bridge:[{}] elected [root] is first:{}", (Object)rootBft.getNodeId(), this.m_domain.getBridgeNodesOnDomain());
            return;
        }
        BridgeForwardingTable oldRootBft = bridgeFtMapCalcul.get(this.m_domain.getRootBridge().getNodeId());
        BridgeSimpleConnection sp = BridgeSimpleConnection.createAndRun(oldRootBft, rootBft);
        rootBft.setRootPort(sp.getSecondBridgePort());
        this.down(oldRootBft, rootBft, sp, bridgeFtMapCalcul, 0);
    }

    public void calculate() {
        BridgeForwardingTable failedBridgeFT;
        BridgeForwardingTable rootBft;
        Bridge electedRoot;
        Assert.notNull(this.m_bridgeFtMapUpdate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: domain\n{}", (Object)this.m_domain.printTopology());
        }
        this.m_parsed = new HashSet<Integer>();
        this.m_failed = new HashSet<Integer>();
        try {
            electedRoot = this.electRootBridge();
        }
        catch (BridgeTopologyException e) {
            LOG.error("calculate: {}, topology:\n{}", new Object[]{e.getMessage(), e.printTopology(), e});
            this.m_failed.addAll(this.m_bridgeFtMapUpdate.keySet());
            return;
        }
        HashMap<Integer, BridgeForwardingTable> bridgeFtMapCalcul = new HashMap<Integer, BridgeForwardingTable>();
        if (this.m_bridgeFtMapUpdate.keySet().equals(this.m_domain.getBridgeNodesOnDomain())) {
            this.m_domain.clearTopology();
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: domain cleaned ->\n{}", (Object)this.m_domain.printTopology());
            }
        } else {
            for (Integer bridgeId : this.m_bridgeFtMapUpdate.keySet()) {
                if (this.m_domain.getBridge(bridgeId).isNewTopology()) {
                    LOG.debug("calculate: bridge:[{}] is 'new'. skip clean topology   ", (Object)bridgeId);
                    continue;
                }
                try {
                    BroadcastDomain.clearTopologyForBridge(this.m_domain, bridgeId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("calculate: bridge:[{}] cleaned ->\n{}", (Object)bridgeId, (Object)this.m_domain.printTopology());
                }
                catch (BridgeTopologyException e) {
                    LOG.warn("calculate: bridge:[{}], {}, \n{}", new Object[]{bridgeId, e.getMessage(), e.printTopology()});
                    this.m_failed.add(bridgeId);
                }
            }
            for (Bridge bridge : this.m_domain.getBridges()) {
                if (this.m_bridgeFtMapUpdate.containsKey(bridge.getNodeId())) continue;
                if (bridge.isNewTopology()) {
                    LOG.warn("calculate: bridge:[{}] is new without update bft", (Object)bridge.getNodeId());
                    continue;
                }
                try {
                    bridgeFtMapCalcul.put(bridge.getNodeId(), BridgeForwardingTable.create(bridge, BroadcastDomain.calculateBFT(this.m_domain, bridge)));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("calculate: bft from domain\n{}", (Object)((BridgeForwardingTable)bridgeFtMapCalcul.get(bridge.getNodeId())).printTopology());
                }
                catch (BridgeTopologyException e) {
                    LOG.warn("calculate: bridge:[{}] clear topology. no calculated bft: {} ->\n{}", new Object[]{bridge.getNodeId(), e.getMessage(), e.printTopology()});
                    this.m_domain.clearTopology();
                    this.calculate();
                }
            }
        }
        if ((rootBft = this.m_bridgeFtMapUpdate.get(electedRoot.getNodeId())) != null) {
            try {
                this.root(rootBft, bridgeFtMapCalcul);
                this.m_parsed.add(rootBft.getNodeId());
            }
            catch (BridgeTopologyException e) {
                LOG.error("calculate: bridge:[{}], {}, \n{}", new Object[]{rootBft.getNodeId(), e.getMessage(), e.printTopology()});
                this.m_failed.addAll(this.m_bridgeFtMapUpdate.keySet());
                return;
            }
        }
        if (rootBft == null) {
            rootBft = (BridgeForwardingTable)bridgeFtMapCalcul.get(electedRoot.getNodeId());
        }
        if (this.m_domain.getRootBridge() != null && this.m_domain.getRootBridge().getNodeId() != electedRoot.getNodeId()) {
            try {
                BroadcastDomain.hierarchySetUp(this.m_domain, electedRoot);
                LOG.debug("calculate: bridge:[{}] elected is new [root] ->\n{}", (Object)electedRoot.getNodeId(), (Object)this.m_domain.printTopology());
            }
            catch (BridgeTopologyException e) {
                LOG.error("calculate: bridge:[{}], {}, \n{}", new Object[]{electedRoot.getNodeId(), e.getMessage(), e.printTopology()});
                this.m_failed.addAll(this.m_bridgeFtMapUpdate.keySet());
                this.m_failed.add(electedRoot.getNodeId());
                return;
            }
        }
        HashSet<Integer> postprocessing = new HashSet<Integer>();
        for (Integer bridgeid : this.m_bridgeFtMapUpdate.keySet()) {
            BridgeSimpleConnection upsimpleconn;
            if (this.m_parsed.contains(bridgeid) || this.m_failed.contains(bridgeid)) continue;
            BridgeForwardingTable bridgeFT = this.m_bridgeFtMapUpdate.get(bridgeid);
            if (bridgeFT.getPorttomac().size() == 1) {
                Integer bridgeFTrootPort = bridgeFT.getPorttomac().iterator().next().getPort().getBridgePort();
                bridgeFT.setRootPort(bridgeFTrootPort);
                postprocessing.add(bridgeid);
                LOG.debug("calculate: bridge:[{}] only one port:[{}] set to root. Postprocessing", (Object)bridgeid, (Object)bridgeFTrootPort);
                continue;
            }
            try {
                upsimpleconn = BridgeSimpleConnection.createAndRun(rootBft, bridgeFT);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("calculate: level: 1, bridge:[{}] -> {}", (Object)bridgeFT.getNodeId(), (Object)upsimpleconn.printTopology());
                }
                bridgeFT.setRootPort(upsimpleconn.getSecondBridgePort());
                LOG.debug("calculate: level: 1, bridge:[{}]. set root port:[{}]", (Object)bridgeFT.getNodeId(), (Object)upsimpleconn.getSecondBridgePort());
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], no root port found. {}, \n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(bridgeid);
                continue;
            }
            try {
                this.down(rootBft, this.m_bridgeFtMapUpdate.get(bridgeid), upsimpleconn, bridgeFtMapCalcul, 0);
                this.m_parsed.add(bridgeid);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], no topology found. {}, \n{}", new Object[]{bridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(bridgeid);
            }
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], first iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], first iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], first iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], second iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], second iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], second iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        for (Integer postprocessbridgeid : new HashSet(postprocessing)) {
            if (postprocessbridgeid == null) {
                LOG.error("calculate: bridge:[null], postprocessbridge");
                continue;
            }
            BridgeForwardingTable postprocessBridgeFT = this.m_bridgeFtMapUpdate.get(postprocessbridgeid);
            if (postprocessBridgeFT == null) {
                LOG.error("calculate: bridge:[{}],postprocessbridge. FT is null", (Object)postprocessbridgeid);
                continue;
            }
            try {
                this.down(rootBft, postprocessBridgeFT, BridgeSimpleConnection.createAndRun(rootBft, postprocessBridgeFT), bridgeFtMapCalcul, 0);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], postprocessbridge. No topology found for single port node. {}, \n{}", new Object[]{postprocessbridgeid, e.getMessage(), e.printTopology()});
                this.m_failed.add(postprocessbridgeid);
                continue;
            }
            this.m_parsed.add(postprocessbridgeid);
        }
        for (Integer failedbridgeid : new HashSet<Integer>(this.m_failed)) {
            if (failedbridgeid == null) {
                LOG.error("calculate: bridge:[null], third iteration on failed");
                continue;
            }
            failedBridgeFT = this.m_bridgeFtMapUpdate.get(failedbridgeid);
            if (failedBridgeFT == null) {
                LOG.error("calculate: bridge:[{}], third iteration on failed. FT is null", (Object)failedbridgeid);
                continue;
            }
            try {
                this.postprocess(failedBridgeFT, rootBft, bridgeFtMapCalcul, new HashSet<Integer>(this.m_parsed));
            }
            catch (BridgeTopologyException e) {
                LOG.warn("calculate: bridge:[{}], third iteration on failed. no topology found. {}, \n{}", new Object[]{failedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            this.m_parsed.add(failedbridgeid);
            this.m_failed.remove(failedbridgeid);
        }
        this.m_bridgeFtMapUpdate.values().stream().filter(ft -> this.m_parsed.contains(ft.getNodeId())).forEach(ft -> BroadcastDomain.addforwarders(this.m_domain, ft));
        bridgeFtMapCalcul.values().stream().forEach(ft -> BroadcastDomain.addforwarders(this.m_domain, ft));
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: domain\n{}", (Object)this.m_domain.printTopology());
        }
    }

    private void postprocess(BridgeForwardingTable postBridgeFT, BridgeForwardingTable rootBridgeFT, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul, Set<Integer> parsed) throws BridgeTopologyException {
        Integer postbridgeid = postBridgeFT.getBridge().getNodeId();
        for (Integer parsedbridgeid : parsed) {
            BridgeSimpleConnection sp;
            if (parsedbridgeid.intValue() == rootBridgeFT.getNodeId().intValue()) continue;
            BridgeForwardingTable parsedBridgeFT = this.m_bridgeFtMapUpdate.get(parsedbridgeid);
            if (parsedBridgeFT == null) {
                parsedBridgeFT = bridgeFtMapCalcul.get(parsedbridgeid);
            }
            try {
                sp = BridgeSimpleConnection.createAndRun(parsedBridgeFT, postBridgeFT);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, parsedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            if (parsedBridgeFT.getBridge().isRootBridge() || parsedBridgeFT.getRootPort().equals(sp.getFirstPort())) continue;
            if (postBridgeFT.getBridge().isNewTopology()) {
                postBridgeFT.setRootPort(sp.getSecondBridgePort());
            }
            try {
                this.down(parsedBridgeFT, postBridgeFT, sp, bridgeFtMapCalcul, 0);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, parsedbridgeid, e.getMessage(), e.printTopology()});
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("postprocess: bridge:[{}] <--> bridge:[{}] topology found.", (Object)postbridgeid, (Object)parsedbridgeid);
            }
            return;
        }
        try {
            this.down(rootBridgeFT, postBridgeFT, BridgeSimpleConnection.createAndRun(rootBridgeFT, postBridgeFT), bridgeFtMapCalcul, 0);
            return;
        }
        catch (BridgeTopologyException e) {
            LOG.warn("postprocess: bridge:[{}] <--> bridge:[{}] no topology found. {}, \n{}", new Object[]{postbridgeid, rootBridgeFT.getNodeId(), e.getMessage(), e.printTopology()});
            throw new BridgeTopologyException("postprocess: no connection found", postBridgeFT);
        }
    }

    private void down(BridgeForwardingTable bridgeUpFT, BridgeForwardingTable bridgeFT, BridgeSimpleConnection upsimpleconn, Map<Integer, BridgeForwardingTable> bridgeFtMapCalcul, Integer level) throws BridgeTopologyException {
        if ((level = Integer.valueOf(level + 1)) == BroadcastDomain.maxlevel) {
            throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], too many iteration");
        }
        SharedSegment upSegment = this.m_domain.getSharedSegment(upsimpleconn.getFirstPort());
        if (upSegment == null) {
            throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], up segment not found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("down: level: {}, bridge:[{}]. up segment -> \n{} ", new Object[]{level, bridgeFT.getNodeId(), upSegment.printTopology()});
        }
        HashSet<BridgePort> parsed = new HashSet<BridgePort>();
        parsed.add(bridgeFT.getRootPort());
        HashSet<BridgeForwardingTable> checkforwarders = new HashSet<BridgeForwardingTable>();
        checkforwarders.add(bridgeUpFT);
        checkforwarders.add(bridgeFT);
        HashMap<BridgePortWithMacs, Set<BridgePortWithMacs>> splitted = new HashMap<BridgePortWithMacs, Set<BridgePortWithMacs>>();
        BridgeForwardingTable nextDownBridge = null;
        BridgeSimpleConnection nextDownSP = null;
        boolean levelfound = false;
        Set<String> maconupsegment = BridgeSimpleConnection.getMacs(bridgeUpFT, bridgeFT, upsimpleconn);
        for (Bridge curbridge : this.m_domain.getBridgeOnSharedSegment(upSegment)) {
            if (curbridge.getNodeId().intValue() == upSegment.getDesignatedBridge().intValue()) continue;
            BridgeForwardingTable curBridgeFT = this.m_bridgeFtMapUpdate.get(curbridge.getNodeId());
            if (curBridgeFT == null) {
                curBridgeFT = bridgeFtMapCalcul.get(curbridge.getNodeId());
            }
            if (curBridgeFT == null) {
                throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], no bft for: " + curbridge.printTopology());
            }
            checkforwarders.add(curBridgeFT);
            BridgeSimpleConnection simpleconn = BridgeSimpleConnection.createAndRun(curBridgeFT, bridgeFT);
            if (LOG.isDebugEnabled()) {
                LOG.debug("down: level: {}, bridge:[{}]. {}", new Object[]{level, bridgeFT.getNodeId(), simpleconn.printTopology()});
            }
            if (simpleconn.getSecondBridgePort() != bridgeFT.getBridge().getRootPort() && simpleconn.getFirstBridgePort() != curbridge.getRootPort()) {
                throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. NO ROOTS");
            }
            if (simpleconn.getSecondBridgePort() == bridgeFT.getRootBridgePort() && simpleconn.getFirstBridgePort() != curbridge.getRootPort()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("down: level: {}, bridge: [{}], is 'down' of -> {}", new Object[]{level, bridgeFT.getNodeId(), simpleconn.getFirstPort().printTopology()});
                }
                if (nextDownBridge != null) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF OF TWO");
                }
                if (levelfound) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF AND LEVEL FOUND");
                }
                nextDownBridge = curBridgeFT;
                nextDownSP = simpleconn;
                continue;
            }
            if (simpleconn.getFirstBridgePort() == curBridgeFT.getRootBridgePort() && simpleconn.getSecondBridgePort() != bridgeFT.getRootBridgePort()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("down: level: {}, bridge: [{}], {} is 'up' of -> [{}]", new Object[]{level, bridgeFT.getNodeId(), simpleconn.getSecondPort().printTopology(), curbridge.getNodeId()});
                }
                if (nextDownBridge != null) {
                    throw new BridgeTopologyException("down: level: " + level + ", bridge:[" + bridgeFT.getNodeId() + "], Topology mismatch. LEAF AND LEVEL FOUND");
                }
                levelfound = true;
                if (!splitted.containsKey(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()))) {
                    splitted.put(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()), new HashSet());
                }
                ((Set)splitted.get(bridgeFT.getBridgePortWithMacs(simpleconn.getSecondPort()))).add(curBridgeFT.getBridgePortWithMacs(simpleconn.getFirstPort()));
                parsed.add(simpleconn.getSecondPort());
                continue;
            }
            maconupsegment.retainAll(BridgeSimpleConnection.getMacs(curBridgeFT, bridgeFT, simpleconn));
        }
        if (nextDownBridge != null) {
            this.down(nextDownBridge, bridgeFT, nextDownSP, bridgeFtMapCalcul, level);
            return;
        }
        SharedSegment.merge(this.m_domain, upSegment, splitted, maconupsegment, bridgeFT.getRootPort(), BridgeForwardingTable.getThroughSet(bridgeFT, parsed));
        checkforwarders.stream().forEach(ft -> BroadcastDomain.addforwarders(this.m_domain, ft));
    }
}

