/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public final class IcmpSocket {
    private static final String LIBRARY_NAME = "jicmp";
    private static final String PROPERTY_NAME = "opennms.library.jicmp";
    private static final String LOGGER_PROPERTY_NAME = "opennms.logger.jicmp";
    private final FileDescriptor m_rawFd;

    private native void initSocket() throws IOException;

    private native void bindSocket(short var1) throws IOException;

    public IcmpSocket(short id) throws IOException {
        String property = System.getProperty(PROPERTY_NAME);
        boolean loaded = false;
        if (property != null) {
            this.log().debug("System property 'opennms.library.jicmp' set to '" + property + ".  Attempting to load " + LIBRARY_NAME + " library from this location.");
            try {
                System.load(property);
                loaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                this.log().info("Failed to load library " + property + ".");
            }
        }
        if (!loaded) {
            this.log().debug("Attempting to load library using System.loadLibrary(\"jicmp\").");
            System.loadLibrary(LIBRARY_NAME);
        }
        this.log().info("Successfully loaded jicmp library.");
        this.m_rawFd = new FileDescriptor();
        this.initSocket();
        this.bindSocket(id);
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().startsWith("windows")) {
            ICMPEchoPacket p = new ICMPEchoPacket(0L);
            p.setIdentity((short)0);
            p.computeChecksum();
            byte[] buf = p.toBytes();
            DatagramPacket dgp = new DatagramPacket(buf, buf.length, InetAddress.getByName("127.0.0.1"), 0);
            this.send(dgp);
        }
    }

    private Logger log() {
        try {
            if (System.getProperty(LOGGER_PROPERTY_NAME) != null) {
                return (Logger)Class.forName(System.getProperty(LOGGER_PROPERTY_NAME)).newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("[WARN] Unable to create jicmp logger from property opennms.logger.jicmp with value " + System.getProperty(LOGGER_PROPERTY_NAME) + ". " + e);
        }
        return new Logger(){

            public void debug(String msg) {
                System.err.println("[DEBUG] " + msg);
            }

            public void info(String msg) {
                System.err.println("[INFO] " + msg);
            }
        };
    }

    public final native void setTrafficClass(int var1) throws IOException;

    public final native void dontFragment() throws IOException;

    public final native DatagramPacket receive() throws IOException;

    public final native void send(DatagramPacket var1) throws IOException;

    public final native void close();

    public static interface Logger {
        public void debug(String var1);

        public void info(String var1);
    }
}

