/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsApplication;

@Entity
@Table(name="bsm_service_applications")
@PrimaryKeyJoinColumn(name="id")
@DiscriminatorValue(value="applications")
public class ApplicationEdgeEntity
extends BusinessServiceEdgeEntity {
    private OnmsApplication m_application;

    @ManyToOne(optional=false)
    @JoinColumn(name="applicationid", nullable=false)
    public OnmsApplication getApplication() {
        return this.m_application;
    }

    public void setApplication(OnmsApplication application) {
        this.m_application = application;
    }

    @Override
    @Transient
    public Set<String> getReductionKeys() {
        return ReductionKeyHelper.getReductionKeys(this.m_application);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("m_application", (Object)this.m_application).toString();
    }

    @Override
    public boolean equalsDefinition(BusinessServiceEdgeEntity other) {
        boolean equalsSuper = super.equalsDefinition(other);
        if (equalsSuper) {
            return Objects.equals(this.m_application, ((ApplicationEdgeEntity)other).m_application);
        }
        return false;
    }

    @Override
    public <T> T accept(EdgeEntityVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

