/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThreadsMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ThreadsProcessor;

@ManagedResource(description="Managed Threads")
public class ManagedThreads
extends ManagedProcessor
implements ManagedThreadsMBean {
    private final ThreadsProcessor processor;

    public ManagedThreads(CamelContext context, ThreadsProcessor processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public Boolean isCallerRunsWhenRejected() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            String name = this.getRejectedPolicy();
            return "CallerRuns".equals(name);
        }
        return null;
    }

    @Override
    public String getRejectedPolicy() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getRejectedExecutionHandler().toString();
        }
        return null;
    }

    @Override
    public int getCorePoolSize() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getCorePoolSize();
        }
        return 0;
    }

    @Override
    public int getPoolSize() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getPoolSize();
        }
        return 0;
    }

    @Override
    public int getMaximumPoolSize() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getMaximumPoolSize();
        }
        return 0;
    }

    @Override
    public int getLargestPoolSize() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getLargestPoolSize();
        }
        return 0;
    }

    @Override
    public int getActiveCount() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getActiveCount();
        }
        return 0;
    }

    @Override
    public long getTaskCount() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getCompletedTaskCount() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueSize() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)this.processor.getExecutorService()).getQueue();
            return queue != null ? (long)queue.size() : 0L;
        }
        return 0L;
    }

    @Override
    public long getKeepAliveTime() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).getKeepAliveTime(TimeUnit.SECONDS);
        }
        return 0L;
    }

    @Override
    public boolean isAllowCoreThreadTimeout() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.processor.getExecutorService()).allowsCoreThreadTimeOut();
        }
        return false;
    }
}

