/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

public final class LoadTriplet {
    private static final double EXP_1 = Math.exp(-0.016666666666666666);
    private static final double EXP_5 = Math.exp(-0.0033333333333333335);
    private static final double EXP_15 = Math.exp(-0.0011111111111111111);
    private double load01 = Double.NaN;
    private double load05 = Double.NaN;
    private double load15 = Double.NaN;

    public void update(int currentReading) {
        this.load01 = this.updateLoad(currentReading, EXP_1, this.load01);
        this.load05 = this.updateLoad(currentReading, EXP_5, this.load05);
        this.load15 = this.updateLoad(currentReading, EXP_15, this.load15);
    }

    private double updateLoad(int reading, double exp, double recentLoad) {
        return Double.isNaN(recentLoad) ? (double)reading : (double)reading + exp * (recentLoad - (double)reading);
    }

    public double getLoad1() {
        return this.load01;
    }

    public double getLoad5() {
        return this.load05;
    }

    public double getLoad15() {
        return this.load15;
    }

    public String toString() {
        return String.format("%.2f, %.2f, %.2f", this.getLoad1(), this.getLoad5(), this.getLoad15());
    }
}

