/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.jolokia.client.request.J4pQueryParameter;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pTargetConfig;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pRequestHandler {
    private URI j4pServerUrl;
    private J4pTargetConfig defaultTargetConfig;
    private static final String ESCAPE = "!";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("!");
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");

    public J4pRequestHandler(String pJ4pServerUrl, J4pTargetConfig pTargetConfig) {
        try {
            this.j4pServerUrl = new URI(pJ4pServerUrl);
            this.defaultTargetConfig = pTargetConfig;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL " + pJ4pServerUrl, e);
        }
    }

    public HttpUriRequest getHttpRequest(J4pRequest pRequest, String pPreferredMethod, Map<J4pQueryParameter, String> pProcessingOptions) throws UnsupportedEncodingException, URISyntaxException {
        String method = pPreferredMethod;
        if (method == null) {
            method = pRequest.getPreferredHttpMethod();
        }
        if (method == null) {
            method = this.doUseProxy(pRequest) ? "POST" : "GET";
        }
        String queryParams = this.prepareQueryParameters(pProcessingOptions);
        if (method.equals("GET")) {
            if (this.doUseProxy(pRequest)) {
                throw new IllegalArgumentException("Proxy mode can only be used with POST requests");
            }
            List<String> parts = pRequest.getRequestParts();
            if (parts != null) {
                String base = this.prepareBaseUrl(this.j4pServerUrl);
                StringBuilder requestPath = new StringBuilder(base);
                requestPath.append(pRequest.getType().getValue());
                for (String p : parts) {
                    requestPath.append("/");
                    requestPath.append(this.escape(p));
                }
                return new HttpGet(this.createRequestURI(requestPath.toString(), queryParams));
            }
        }
        JSONObject requestContent = this.getJsonRequestContent(pRequest);
        HttpPost postReq = new HttpPost(this.createRequestURI(this.j4pServerUrl.getPath(), queryParams));
        postReq.setEntity((HttpEntity)new StringEntity(requestContent.toJSONString(), "utf-8"));
        return postReq;
    }

    private boolean doUseProxy(J4pRequest pRequest) {
        return this.defaultTargetConfig != null || pRequest.getTargetConfig() != null;
    }

    private String prepareBaseUrl(URI pUri) {
        String base = pUri.getPath();
        if (base == null) {
            return "/";
        }
        if (!base.endsWith("/")) {
            return base + "/";
        }
        return base;
    }

    public <T extends J4pRequest> HttpUriRequest getHttpRequest(List<T> pRequests, Map<J4pQueryParameter, String> pProcessingOptions) throws UnsupportedEncodingException, URISyntaxException {
        JSONArray bulkRequest = new JSONArray();
        String queryParams = this.prepareQueryParameters(pProcessingOptions);
        HttpPost postReq = new HttpPost(this.createRequestURI(this.j4pServerUrl.getPath(), queryParams));
        for (J4pRequest request : pRequests) {
            JSONObject requestContent = this.getJsonRequestContent(request);
            bulkRequest.add((Object)requestContent);
        }
        postReq.setEntity((HttpEntity)new StringEntity(bulkRequest.toJSONString(), "utf-8"));
        return postReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONAware extractJsonResponse(HttpResponse pHttpResponse) throws IOException, ParseException {
        HttpEntity entity = pHttpResponse.getEntity();
        try {
            JSONParser parser = new JSONParser();
            Header contentEncoding = entity.getContentEncoding();
            if (contentEncoding != null) {
                JSONAware jSONAware = (JSONAware)parser.parse((Reader)new InputStreamReader(entity.getContent(), Charset.forName(contentEncoding.getValue())));
                return jSONAware;
            }
            JSONAware jSONAware = (JSONAware)parser.parse((Reader)new InputStreamReader(entity.getContent()));
            return jSONAware;
        }
        finally {
            if (entity != null) {
                entity.consumeContent();
            }
        }
    }

    public URI getJ4pServerUrl() {
        return this.j4pServerUrl;
    }

    private JSONObject getJsonRequestContent(J4pRequest pRequest) {
        JSONObject requestContent = pRequest.toJson();
        if (this.defaultTargetConfig != null && pRequest.getTargetConfig() == null) {
            requestContent.put((Object)"target", (Object)this.defaultTargetConfig.toJson());
        }
        return requestContent;
    }

    private String escape(String pPart) {
        String ret = ESCAPE_PATTERN.matcher(pPart).replaceAll("!!");
        return SLASH_PATTERN.matcher(ret).replaceAll("!/");
    }

    private URI createRequestURI(String path, String queryParams) throws URISyntaxException {
        return new URI(this.j4pServerUrl.getScheme(), this.j4pServerUrl.getUserInfo(), this.j4pServerUrl.getHost(), this.j4pServerUrl.getPort(), path, queryParams, null);
    }

    private String prepareQueryParameters(Map<J4pQueryParameter, String> pProcessingOptions) {
        if (pProcessingOptions != null && pProcessingOptions.size() > 0) {
            StringBuilder queryParams = new StringBuilder();
            for (Map.Entry<J4pQueryParameter, String> entry : pProcessingOptions.entrySet()) {
                queryParams.append(entry.getKey().getParam()).append("=").append(entry.getValue()).append("&");
            }
            return queryParams.substring(0, queryParams.length() - 1);
        }
        return null;
    }
}

