/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.minion;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.common.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.distributed.common.MapBasedListenerDef;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;
import org.opennms.netmgt.telemetry.distributed.minion.ListenerHealthCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerManager
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerManager.class);
    private MessageDispatcherFactory messageDispatcherFactory;
    private DistPollerDao distPollerDao;
    private TelemetryRegistry telemetryRegistry;
    private Map<String, Entity> entities = new LinkedHashMap<String, Entity>();
    private BundleContext bundleContext;

    public String getName() {
        return "Manages telemetry listener lifecycle.";
    }

    public void updated(String pid, Dictionary<String, ?> properties) {
        if (this.entities.containsKey(pid)) {
            LOG.info("Updating existing listener/dispatcher for pid: {}", (Object)pid);
            this.deleted(pid);
        } else {
            LOG.info("Creating new listener/dispatcher for pid: {}", (Object)pid);
        }
        PropertyTree definition = PropertyTree.from(properties);
        MapBasedListenerDef listenerDef = new MapBasedListenerDef(definition);
        ListenerHealthCheck healthCheck = new ListenerHealthCheck((ListenerDefinition)listenerDef);
        Entity entity = new Entity();
        entity.healthCheck = this.bundleContext.registerService(HealthCheck.class, (Object)healthCheck, null);
        try {
            listenerDef.getParsers().stream().forEach(parserDef -> {
                if (this.telemetryRegistry.getDispatcher(parserDef.getQueueName()) != null) {
                    throw new IllegalArgumentException("A queue with name " + parserDef.getQueueName() + " is already defined. Bailing.");
                }
                TelemetrySinkModule sinkModule = new TelemetrySinkModule((QueueDefinition)parserDef);
                sinkModule.setDistPollerDao(this.distPollerDao);
                AsyncDispatcher dispatcher = this.messageDispatcherFactory.createAsyncDispatcher((SinkModule)sinkModule);
                String queueName = Objects.requireNonNull(parserDef.getQueueName());
                this.telemetryRegistry.registerDispatcher(queueName, dispatcher);
                entity.queueNames.add(parserDef.getQueueName());
            });
            entity.listener = this.telemetryRegistry.getListener((ListenerDefinition)listenerDef);
            entity.listener.start();
            healthCheck.markSucess();
            this.entities.put(pid, entity);
        }
        catch (Exception e) {
            LOG.error("Failed to build listener.", (Throwable)e);
            healthCheck.markError(e);
            this.stopQueues(entity.queueNames);
        }
        LOG.info("Successfully started listener/dispatcher for pid: {}", (Object)pid);
    }

    public void deleted(String pid) {
        Entity entity = this.entities.remove(pid);
        if (entity.healthCheck != null) {
            entity.healthCheck.unregister();
        }
        if (entity.listener != null) {
            LOG.info("Stopping listener for pid: {}", (Object)pid);
            try {
                entity.listener.stop();
            }
            catch (InterruptedException e) {
                LOG.error("Error occurred while stopping listener for pid: {}", (Object)pid, (Object)e);
            }
        }
        if (entity.queueNames != null) {
            this.stopQueues(entity.queueNames);
        }
    }

    public void init() {
        LOG.info("ListenerManager started.");
    }

    public void destroy() {
        new ArrayList<String>(this.entities.keySet()).forEach(pid -> this.deleted((String)pid));
        LOG.info("ListenerManager stopped.");
    }

    public MessageDispatcherFactory getMessageDispatcherFactory() {
        return this.messageDispatcherFactory;
    }

    public void setMessageDispatcherFactory(MessageDispatcherFactory messageDispatcherFactory) {
        this.messageDispatcherFactory = messageDispatcherFactory;
    }

    public DistPollerDao getDistPollerDao() {
        return this.distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setTelemetryRegistry(TelemetryRegistry telemetryRegistry) {
        this.telemetryRegistry = telemetryRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopQueues(Set<String> queueNames) {
        Objects.requireNonNull(queueNames);
        for (String queueName : queueNames) {
            try {
                AsyncDispatcher dispatcher = this.telemetryRegistry.getDispatcher(queueName);
                dispatcher.close();
            }
            catch (Exception ex) {
                LOG.error("Failed to close dispatcher.", (Throwable)ex);
            }
            finally {
                this.telemetryRegistry.removeDispatcher(queueName);
            }
        }
    }

    private static class Entity {
        private Listener listener;
        private Set<String> queueNames = new HashSet<String>();
        private ServiceRegistration<HealthCheck> healthCheck;

        private Entity() {
        }
    }
}

