/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.client.rpc;

import java.util.Objects;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.utils.RpcTargetHelper;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.netmgt.collection.api.CollectorRequestBuilder;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.client.rpc.CollectorClientRpcModule;
import org.opennms.netmgt.collection.client.rpc.CollectorRequestBuilderImpl;
import org.opennms.netmgt.collection.client.rpc.CollectorRequestDTO;
import org.opennms.netmgt.collection.client.rpc.CollectorResponseDTO;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationAwareCollectorClientImpl
implements LocationAwareCollectorClient,
InitializingBean {
    @Autowired
    private CollectorClientRpcModule rpcModule;
    @Autowired
    private RpcClientFactory rpcClientFactory;
    @Autowired
    private RpcTargetHelper rpcTargetHelper;
    @Autowired
    private EntityScopeProvider entityScopeProvider;
    private RpcClient<CollectorRequestDTO, CollectorResponseDTO> delegate;

    public LocationAwareCollectorClientImpl() {
    }

    public LocationAwareCollectorClientImpl(RpcClientFactory rpcClientFactory) {
        this.rpcClientFactory = Objects.requireNonNull(rpcClientFactory);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.delegate = this.rpcClientFactory.getClient((RpcModule)this.rpcModule);
    }

    protected RpcClient<CollectorRequestDTO, CollectorResponseDTO> getDelegate() {
        return this.delegate;
    }

    public CollectorRequestBuilder collect() {
        return new CollectorRequestBuilderImpl(this);
    }

    public void setRpcModule(CollectorClientRpcModule rpcModule) {
        this.rpcModule = rpcModule;
    }

    public ServiceCollectorRegistry getRegistry() {
        return this.rpcModule.getServiceCollectorRegistry();
    }

    public RpcTargetHelper getRpcTargetHelper() {
        return this.rpcTargetHelper;
    }

    public void setRpcTargetHelper(RpcTargetHelper rpcTargetHelper) {
        this.rpcTargetHelper = rpcTargetHelper;
    }

    public EntityScopeProvider getEntityScopeProvider() {
        return this.entityScopeProvider;
    }

    public void setEntityScopeProvider(EntityScopeProvider entityScopeProvider) {
        this.entityScopeProvider = entityScopeProvider;
    }
}

