/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.client.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opennms.core.logging.Logging;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.client.rpc.CollectorRequestDTO;
import org.opennms.netmgt.collection.client.rpc.CollectorResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CollectorClientRpcModule
extends AbstractXmlRpcModule<CollectorRequestDTO, CollectorResponseDTO> {
    public static final String RPC_MODULE_ID = "Collect";
    @Autowired
    private ServiceCollectorRegistry serviceCollectorRegistry;
    @Autowired
    @Qualifier(value="collectorExecutor")
    private Executor executor;

    public CollectorClientRpcModule() {
        super(CollectorRequestDTO.class, CollectorResponseDTO.class);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public CompletableFuture<CollectorResponseDTO> execute(final CollectorRequestDTO request) {
        String className = request.getClassName();
        final ServiceCollector collector = this.serviceCollectorRegistry.getCollectorByClassName(className);
        if (collector == null) {
            throw new IllegalArgumentException("No collector found with class name '" + className + "'.");
        }
        return CompletableFuture.supplyAsync(new Supplier<CollectorResponseDTO>(){

            @Override
            public CollectorResponseDTO get() {
                Logging.putPrefix((String)"collectd");
                CollectionAgent agent = request.getAgent();
                Map<String, Object> parameters = request.getParameters(collector);
                return new CollectorResponseDTO(collector.collect(agent, parameters));
            }
        }, this.executor);
    }

    public void setServiceCollectorRegistry(ServiceCollectorRegistry serviceCollectorRegistry) {
        this.serviceCollectorRegistry = serviceCollectorRegistry;
    }

    public ServiceCollectorRegistry getServiceCollectorRegistry() {
        return this.serviceCollectorRegistry;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public CollectorResponseDTO createResponseWithException(Throwable ex) {
        return new CollectorResponseDTO(ex);
    }
}

