/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.WSManVersion;
import org.opennms.netmgt.config.wsman.Definition;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.config.wsman.WsmanConfig;

public interface WSManConfigDao {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_PATH = "/wsman";

    public WsmanConfig getConfig();

    public Definition getAgentConfig(InetAddress var1);

    public WSManEndpoint getEndpoint(InetAddress var1);

    public static WSManEndpoint getEndpoint(WsmanAgentConfig agentConfig, InetAddress agentInetAddress) {
        URL url;
        Objects.requireNonNull(agentConfig, "agentConfig argument");
        Objects.requireNonNull(agentInetAddress, "agentInetAddress argument");
        try {
            String protocol = DEFAULT_PROTOCOL;
            if (agentConfig.isSsl() != null) {
                protocol = agentConfig.isSsl() != false ? "https" : DEFAULT_PROTOCOL;
            }
            String port = "";
            if (agentConfig.getPort() != null) {
                port = String.format(":%d", agentConfig.getPort());
            }
            String path = DEFAULT_PATH;
            if (agentConfig.getPath() != null) {
                path = agentConfig.getPath();
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            String host = agentInetAddress.getHostAddress();
            if (agentConfig.isGssAuth() != null && agentConfig.isGssAuth().booleanValue()) {
                host = agentInetAddress.getCanonicalHostName();
            }
            url = new URL(String.format("%s://%s%s%s", protocol, host, port, path));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid endpoint URL: " + e.getMessage());
        }
        WSManEndpoint.Builder builder = new WSManEndpoint.Builder(url).withServerVersion(WSManVersion.WSMAN_1_0);
        if (agentConfig.getUsername() != null && agentConfig.getPassword() != null) {
            builder.withBasicAuth(agentConfig.getUsername(), agentConfig.getPassword());
        }
        if (agentConfig.isGssAuth() != null && agentConfig.isGssAuth().booleanValue()) {
            builder.withGSSAuth();
        }
        if (agentConfig.getMaxElements() != null) {
            builder.withMaxElements(agentConfig.getMaxElements());
        }
        if (agentConfig.isStrictSsl() != null) {
            builder.withStrictSSL(false);
        }
        if (agentConfig.getTimeout() != null) {
            builder.withConnectionTimeout(agentConfig.getTimeout()).withReceiveTimeout(agentConfig.getTimeout());
        }
        return builder.build();
    }
}

