/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.swrve.ratelimitedlogger.LogWithPatternAndLevel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class Registry {
    private static final Logger logger = LoggerFactory.getLogger(Registry.class);
    private final ConcurrentHashMap<Duration, ConcurrentHashMap<LogWithPatternAndLevel, Boolean>> registry = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RateLimitedLogRegistry-%d").setDaemon(true).build();
    private final ScheduledExecutorService resetScheduler = Executors.newScheduledThreadPool(1, this.threadFactory);

    Registry() {
    }

    synchronized void register(LogWithPatternAndLevel log, Duration period) {
        boolean needToScheduleReset = false;
        ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod = this.registry.get(period);
        if (logLinesForPeriod == null) {
            needToScheduleReset = true;
            logLinesForPeriod = new ConcurrentHashMap();
            this.registry.put(period, logLinesForPeriod);
        } else if (logLinesForPeriod.get(log) != null) {
            return;
        }
        logLinesForPeriod.put(log, Boolean.TRUE);
        if (needToScheduleReset) {
            final ConcurrentHashMap<LogWithPatternAndLevel, Boolean> finalLogLinesForPeriod = logLinesForPeriod;
            this.resetScheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        Registry.this.resetAllCounters(finalLogLinesForPeriod);
                    }
                    catch (Exception e) {
                        logger.warn("failed to reset counters: " + e, (Throwable)e);
                    }
                }
            }, period.getMillis(), period.getMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void resetAllCounters(ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod) {
        for (LogWithPatternAndLevel log : logLinesForPeriod.keySet()) {
            log.periodicReset();
        }
    }

    synchronized void flush() {
        for (Map.Entry<Duration, ConcurrentHashMap<LogWithPatternAndLevel, Boolean>> entry : this.registry.entrySet()) {
            ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod = entry.getValue();
            this.resetAllCounters(logLinesForPeriod);
            logLinesForPeriod.clear();
        }
    }
}

