/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.swrve.ratelimitedlogger.CounterMetric;
import com.swrve.ratelimitedlogger.Level;
import com.swrve.ratelimitedlogger.LogWithPatternAndLevel;
import com.swrve.ratelimitedlogger.Registry;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.Marker;

@ThreadSafe
public class RateLimitedLogWithPattern {
    private final String message;
    private final RateAndPeriod rateAndPeriod;
    private final Logger logger;
    private final Registry registry;
    private final Optional<CounterMetric> stats;
    private final Stopwatch stopwatch;
    private final AtomicReferenceArray<LogWithPatternAndLevel> levels;

    RateLimitedLogWithPattern(String message, RateAndPeriod rateAndPeriod, Registry registry, Optional<CounterMetric> stats, Stopwatch stopwatch, Logger logger) {
        this.message = message;
        this.rateAndPeriod = rateAndPeriod;
        this.registry = registry;
        this.logger = logger;
        this.stats = stats;
        this.stopwatch = stopwatch;
        this.levels = new AtomicReferenceArray(Level.values().length);
    }

    public void trace(Object ... args) {
        this.get(Level.TRACE).log(args);
    }

    public void trace(Throwable t) {
        this.get(Level.TRACE).log(t);
    }

    public void trace(Marker marker, Object ... args) {
        this.get(Level.TRACE).log(marker, args);
    }

    public void trace(Marker marker, Throwable t) {
        this.get(Level.TRACE).log(marker, t);
    }

    public void debug(Object ... args) {
        this.get(Level.DEBUG).log(args);
    }

    public void debug(Throwable t) {
        this.get(Level.DEBUG).log(t);
    }

    public void debug(Marker marker, Object ... args) {
        this.get(Level.DEBUG).log(marker, args);
    }

    public void debug(Marker marker, Throwable t) {
        this.get(Level.DEBUG).log(marker, t);
    }

    public void info(Object ... args) {
        this.get(Level.INFO).log(args);
    }

    public void info(Throwable t) {
        this.get(Level.INFO).log(t);
    }

    public void info(Marker marker, Object ... args) {
        this.get(Level.INFO).log(marker, args);
    }

    public void info(Marker marker, Throwable t) {
        this.get(Level.INFO).log(marker, t);
    }

    public void warn(Object ... args) {
        this.get(Level.WARN).log(args);
    }

    public void warn(Throwable t) {
        this.get(Level.WARN).log(t);
    }

    public void warn(Marker marker, Object ... args) {
        this.get(Level.WARN).log(marker, args);
    }

    public void warn(Marker marker, Throwable t) {
        this.get(Level.WARN).log(marker, t);
    }

    public void error(Object ... args) {
        this.get(Level.ERROR).log(args);
    }

    public void error(Throwable t) {
        this.get(Level.ERROR).log(t);
    }

    public void error(Marker marker, Object ... args) {
        this.get(Level.ERROR).log(marker, args);
    }

    public void error(Marker marker, Throwable t) {
        this.get(Level.ERROR).log(marker, t);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.message.equals(((RateLimitedLogWithPattern)o).message);
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public LogWithPatternAndLevel get(Level level) {
        int l = level.ordinal();
        LogWithPatternAndLevel got = this.levels.get(l);
        if (got != null) {
            return got;
        }
        LogWithPatternAndLevel newValue = new LogWithPatternAndLevel(this.message, level, this.rateAndPeriod, this.stats, this.stopwatch, this.logger);
        boolean wasSet = this.levels.compareAndSet(l, null, newValue);
        if (!wasSet) {
            return (LogWithPatternAndLevel)Preconditions.checkNotNull((Object)this.levels.get(l));
        }
        this.registry.register(newValue, this.rateAndPeriod.periodLength);
        return newValue;
    }

    public static final class RateAndPeriod {
        final int maxRate;
        final Duration periodLength;

        public RateAndPeriod(int maxRate, Duration periodLength) {
            this.maxRate = maxRate;
            this.periodLength = periodLength;
        }
    }
}

