/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.swrve.ratelimitedlogger.CounterMetric;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import com.swrve.ratelimitedlogger.RateLimitedLogWithPattern;
import net.jcip.annotations.NotThreadSafe;
import org.joda.time.Duration;
import org.slf4j.Logger;

@NotThreadSafe
public class RateLimitedLogBuilder {
    private final Logger logger;
    private final int maxRate;
    private final Duration periodLength;
    private Stopwatch stopwatch = Stopwatch.createUnstarted();
    private Optional<CounterMetric> stats = Optional.absent();

    private RateLimitedLogBuilder(Logger logger, int maxRate, Duration periodLength) {
        this.logger = logger;
        this.maxRate = maxRate;
        this.periodLength = periodLength;
    }

    public RateLimitedLogBuilder withStopwatch(Stopwatch stopwatch) {
        this.stopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch);
        return this;
    }

    public RateLimitedLogBuilder recordMetrics(CounterMetric stats) {
        this.stats = Optional.of((Object)Preconditions.checkNotNull((Object)stats));
        return this;
    }

    public RateLimitedLog build() {
        Preconditions.checkArgument((this.maxRate > 0 ? 1 : 0) != 0, (Object)"maxRate must be > 0");
        Preconditions.checkArgument((this.periodLength.getMillis() > 0L ? 1 : 0) != 0, (Object)"period must be non-zero");
        this.stopwatch.start();
        return new RateLimitedLog(this.logger, new RateLimitedLogWithPattern.RateAndPeriod(this.maxRate, this.periodLength), this.stopwatch, this.stats, RateLimitedLog.REGISTRY);
    }

    public static class MissingPeriod {
        private final Logger logger;
        private final int maxRate;

        private MissingPeriod(Logger logger, int rate) {
            Preconditions.checkNotNull((Object)logger);
            this.logger = logger;
            this.maxRate = rate;
        }

        public RateLimitedLogBuilder every(Duration duration) {
            Preconditions.checkNotNull((Object)duration);
            return new RateLimitedLogBuilder(this.logger, this.maxRate, duration);
        }
    }

    public static class MissingRateAndPeriod {
        private final Logger logger;

        MissingRateAndPeriod(Logger logger) {
            this.logger = logger;
        }

        public MissingPeriod maxRate(int rate) {
            return new MissingPeriod(this.logger, rate);
        }
    }
}

