/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.RestRegistryListCommand;
import org.apache.camel.karaf.commands.completers.CamelContextCompleter;
import org.apache.camel.karaf.commands.internal.CamelControllerImpl;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="camel", name="rest-registry-list", description="Lists all Camel REST services enlisted in the Rest Registry from a CamelContext")
@Service
public class RestRegistryList
extends CamelControllerImpl
implements Action {
    @Argument(index=0, name="name", description="The Camel context name where to look for the REST services", required=true, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;
    @Option(name="--decode", aliases={"-d"}, description="Whether to decode the endpoint uri so its human readable", required=false, multiValued=false, valueToShowInHelp="true")
    Boolean decode = true;
    @Option(name="--verbose", aliases={"-v"}, description="Verbose output which does not limit the length of the uri shown", required=false, multiValued=false, valueToShowInHelp="false")
    Boolean verbose = false;

    public Object execute() throws Exception {
        RestRegistryListCommand command = new RestRegistryListCommand(this.name, this.decode.booleanValue(), this.verbose.booleanValue());
        return command.execute((CamelController)this, System.out, System.err);
    }
}

