/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Thresholder;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="threshd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="thresholding.xsd")
public class ThreshdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="threads", required=true)
    private Integer m_threads;
    @XmlElement(name="package", required=true)
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="thresholder")
    private List<Thresholder> m_thresholders = new ArrayList<Thresholder>();

    public Integer getThreads() {
        return this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = ConfigUtils.assertNotNull(threads, "threads");
    }

    public List<Package> getPackages() {
        return this.m_packages;
    }

    public void setPackages(List<Package> packages) {
        if (packages == this.m_packages) {
            return;
        }
        this.m_packages.clear();
        if (packages != null) {
            this.m_packages.addAll(packages);
        }
    }

    public void addPackage(Package p) {
        this.m_packages.add(p);
    }

    public boolean removePackage(Package p) {
        return this.m_packages.remove(p);
    }

    public List<Thresholder> getThresholders() {
        return this.m_thresholders;
    }

    public void setThresholders(List<Thresholder> thresholders) {
        if (thresholders == this.m_thresholders) {
            return;
        }
        this.m_thresholders.clear();
        if (thresholders != null) {
            this.m_thresholders.addAll(thresholders);
        }
    }

    public void addThresholder(Thresholder thresholder) {
        this.m_thresholders.add(thresholder);
    }

    public boolean removeThresholder(Thresholder thresholder) {
        return this.m_thresholders.remove(thresholder);
    }

    public int hashCode() {
        return Objects.hash(this.m_threads, this.m_packages, this.m_thresholders);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThreshdConfiguration) {
            ThreshdConfiguration that = (ThreshdConfiguration)obj;
            return Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_packages, that.m_packages) && Objects.equals(this.m_thresholders, that.m_thresholders);
        }
        return false;
    }
}

