/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpinterfacepoller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.snmpinterfacepoller.NodeOutage;
import org.opennms.netmgt.config.snmpinterfacepoller.Package;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="snmp-interface-poller-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-interface-poller-configuration.xsd")
public class SnmpInterfacePollerConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="interval")
    private Long m_interval;
    @XmlAttribute(name="threads", required=true)
    private Integer m_threads;
    @XmlAttribute(name="service", required=true)
    private String m_service;
    @XmlAttribute(name="suppressAdminDownEvent")
    private Boolean m_suppressAdminDownEvent;
    @XmlAttribute(name="useCriteriaFilters")
    private Boolean m_useCriteriaFilters;
    @XmlElement(name="node-outage", required=true)
    private NodeOutage m_nodeOutage;
    @XmlElement(name="package", required=true)
    private List<Package> m_packages = new ArrayList<Package>();

    public Long getInterval() {
        return this.m_interval != null ? this.m_interval : Long.valueOf("300000");
    }

    public void setInterval(Long interval) {
        this.m_interval = ConfigUtils.assertNotNull(interval, "interval");
    }

    public Integer getThreads() {
        return this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = ConfigUtils.assertNotNull(threads, "threads");
    }

    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        this.m_service = ConfigUtils.assertNotEmpty(service, "service");
    }

    public Boolean getSuppressAdminDownEvent() {
        return this.m_suppressAdminDownEvent != null ? this.m_suppressAdminDownEvent : Boolean.TRUE;
    }

    public void setSuppressAdminDownEvent(Boolean suppressAdminDownEvent) {
        this.m_suppressAdminDownEvent = suppressAdminDownEvent;
    }

    public Boolean getUseCriteriaFilters() {
        return this.m_useCriteriaFilters != null ? this.m_useCriteriaFilters : Boolean.FALSE;
    }

    public void setUseCriteriaFilters(Boolean useCriteriaFilters) {
        this.m_useCriteriaFilters = useCriteriaFilters;
    }

    public NodeOutage getNodeOutage() {
        return this.m_nodeOutage;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this.m_nodeOutage = ConfigUtils.assertNotNull(nodeOutage, "nodeOutage");
    }

    public List<Package> getPackages() {
        return this.m_packages;
    }

    public void setPackages(List<Package> packages) {
        ConfigUtils.assertMinimumSize(packages, 1L, "package");
        if (packages == this.m_packages) {
            return;
        }
        this.m_packages.clear();
        if (packages != null) {
            this.m_packages.addAll(packages);
        }
    }

    public void addPackage(Package p) {
        this.m_packages.add(p);
    }

    public boolean removePackage(Package p) {
        return this.m_packages.remove(p);
    }

    public int hashCode() {
        return Objects.hash(this.m_interval, this.m_threads, this.m_service, this.m_suppressAdminDownEvent, this.m_useCriteriaFilters, this.m_nodeOutage, this.m_packages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SnmpInterfacePollerConfiguration) {
            SnmpInterfacePollerConfiguration that = (SnmpInterfacePollerConfiguration)obj;
            return Objects.equals(this.m_interval, that.m_interval) && Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_service, that.m_service) && Objects.equals(this.m_suppressAdminDownEvent, that.m_suppressAdminDownEvent) && Objects.equals(this.m_useCriteriaFilters, that.m_useCriteriaFilters) && Objects.equals(this.m_nodeOutage, that.m_nodeOutage) && Objects.equals(this.m_packages, that.m_packages);
        }
        return false;
    }
}

