/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="requisition-def")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="provisiond-configuration.xsd")
public class RequisitionDef
implements Serializable {
    private static final List<String> RESCAN_EXISTING_OPTIONS = Arrays.asList("true", "false", "dbonly");
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_RESCAN_EXISTING = System.getProperty("org.opennms.provisiond.scheduleRescanForUpdatedNodes", "true");
    @XmlAttribute(name="import-url-resource", required=true)
    private String m_importUrlResource;
    @XmlAttribute(name="import-name", required=true)
    private String m_importName;
    @XmlAttribute(name="rescan-existing")
    private String m_rescanExisting;
    @XmlElement(name="cron-schedule", required=true)
    private String m_cronSchedule;

    public Optional<String> getImportUrlResource() {
        return Optional.ofNullable(this.m_importUrlResource);
    }

    public void setImportUrlResource(String importUrlResource) {
        this.m_importUrlResource = ConfigUtils.assertNotEmpty(importUrlResource, "import-url-resource");
    }

    public Optional<String> getImportName() {
        return Optional.ofNullable(this.m_importName);
    }

    public void setImportName(String importName) {
        this.m_importName = ConfigUtils.assertNotEmpty(importName, "import-name");
    }

    public String getRescanExisting() {
        return this.m_rescanExisting != null ? this.m_rescanExisting : DEFAULT_RESCAN_EXISTING;
    }

    public void setRescanExisting(String rescanExisting) {
        this.m_rescanExisting = ConfigUtils.assertOnlyContains(ConfigUtils.normalizeString(rescanExisting), RESCAN_EXISTING_OPTIONS, "rescan-existing");
    }

    public Optional<String> getCronSchedule() {
        return Optional.ofNullable(this.m_cronSchedule);
    }

    public void setCronSchedule(String cronSchedule) {
        this.m_cronSchedule = ConfigUtils.assertNotEmpty(cronSchedule, "cron-schedule");
    }

    public int hashCode() {
        return Objects.hash(this.m_importUrlResource, this.m_importName, this.m_rescanExisting, this.m_cronSchedule);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RequisitionDef) {
            RequisitionDef that = (RequisitionDef)obj;
            return Objects.equals(this.m_importUrlResource, that.m_importUrlResource) && Objects.equals(this.m_importName, that.m_importName) && Objects.equals(this.m_rescanExisting, that.m_rescanExisting) && Objects.equals(this.m_cronSchedule, that.m_cronSchedule);
        }
        return false;
    }
}

