/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcServerProcessor
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerProcessor.class);
    private final RpcModule<RpcRequest, RpcResponse> module;
    private final TracerRegistry tracerRegistry;
    private Tracer tracer;

    public CamelRpcServerProcessor(RpcModule<RpcRequest, RpcResponse> module, TracerRegistry tracerRegistry) {
        this.module = Objects.requireNonNull(module);
        this.tracerRegistry = Objects.requireNonNull(tracerRegistry);
    }

    public void process(Exchange exchange) {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        HashMap<String, String> tracingInfo = new HashMap<String, String>();
        Tracer.SpanBuilder spanBuilder = this.buildSpanFromHeaders(exchange.getIn(), tracingInfo);
        Span minionSpan = spanBuilder.start();
        tracingInfo.forEach((arg_0, arg_1) -> ((Span)minionSpan).setTag(arg_0, arg_1));
        RpcRequest request = this.module.unmarshalRequest((String)exchange.getIn().getBody(String.class));
        minionSpan.setTag("location", request.getLocation());
        if (request.getSystemId() != null) {
            minionSpan.setTag("systemId", request.getSystemId());
        }
        CompletableFuture future = this.module.execute(request);
        future.whenComplete((res, ex) -> {
            try {
                RpcResponse response;
                if (ex != null) {
                    LOG.warn("An error occured while executing a call in {}.", (Object)this.module.getId(), ex);
                    response = this.module.createResponseWithException(ex);
                    minionSpan.setTag("failed", "true");
                    minionSpan.log(ex.getMessage());
                } else {
                    response = res;
                }
                minionSpan.finish();
                try {
                    exchange.getOut().setBody((Object)this.module.marshalResponse(response), String.class);
                    this.postProcess(exchange);
                }
                catch (Throwable t) {
                    LOG.error("Marshalling a response in RPC module {} failed.", this.module, (Object)t);
                    exchange.setException(t);
                    exchange.getOut().setFault(true);
                }
            }
            finally {
                callback.done(false);
            }
        });
        return false;
    }

    public String toString() {
        return String.format("%s[module=%s]", super.toString(), this.module.toString());
    }

    public void postProcess(Exchange exchange) {
    }

    private Tracer.SpanBuilder buildSpanFromHeaders(Message message, Map<String, String> tracingInfo) {
        SpanContext context;
        Tracer tracer = this.tracerRegistry.getTracer();
        String tracingInfoObj = (String)message.getHeader("RpcTracingInfo", String.class);
        if (tracingInfoObj != null) {
            tracingInfo.putAll(TracingInfoCarrier.unmarshalTracinginfo((String)tracingInfoObj));
        }
        Tracer.SpanBuilder spanBuilder = (context = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapExtractAdapter(tracingInfo))) != null ? tracer.buildSpan(this.module.getId()).asChildOf(context) : tracer.buildSpan(this.module.getId());
        return spanBuilder;
    }
}

