/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.common;

public class RpcStrategy {
    public static final String RPC_STRATEGY_PROPERTY = "org.opennms.core.ipc.rpc.strategy";
    private static final String JMS_RPC_STRATEGY_NAME = "jms";
    private static final String SQS_RPC_STRATEGY_NAME = "sqs";
    private static final String KAFKA_RPC_STRATEGY_NAME = "kafka";

    public static Strategy getRpcStrategy() {
        String effectiveStrategyName = System.getProperty(RPC_STRATEGY_PROPERTY, JMS_RPC_STRATEGY_NAME);
        for (Strategy strategy : Strategy.values()) {
            if (!strategy.getName().equalsIgnoreCase(effectiveStrategyName)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unsupported RPC strategy: " + effectiveStrategyName);
    }

    public static enum Strategy {
        JMS("jms", "JMS implementation using Camel"),
        SQS("sqs", "Amazon SQS implementation"),
        KAFKA("kafka", "Kafka implementation");

        private final String m_name;
        private final String m_descr;

        private Strategy(String name, String descr) {
            this.m_name = name;
            this.m_descr = descr;
        }

        private Strategy(String name) {
            this(name, name);
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescr() {
            return this.m_descr;
        }
    }
}

