/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class PrimaryType
implements Comparable<PrimaryType>,
Serializable {
    private static final long serialVersionUID = -647348487361201657L;
    private static final char[] s_order = new char[]{'N', 'S', 'P'};
    private char m_collType;
    public static final PrimaryType PRIMARY = new PrimaryType('P');
    public static final PrimaryType SECONDARY = new PrimaryType('S');
    public static final PrimaryType NOT_ELIGIBLE = new PrimaryType('N');

    protected PrimaryType() {
        this('N');
    }

    PrimaryType(char collType) {
        this.m_collType = collType;
    }

    @Transient
    public String getCode() {
        return String.valueOf(this.m_collType);
    }

    @Column(name="isSnmpPrimary")
    public char getCharCode() {
        return this.m_collType;
    }

    public void setCharCode(char collType) {
        this.m_collType = collType;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PrimaryType) {
            return this.compareTo((PrimaryType)o) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(PrimaryType collType) {
        return PrimaryType.getIndex(this.m_collType) - PrimaryType.getIndex(collType.m_collType);
    }

    private static int getIndex(char code) {
        for (int i = 0; i < s_order.length; ++i) {
            if (s_order[i] != code) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal collType code '" + code + "'");
    }

    public String toString() {
        return String.valueOf(this.m_collType);
    }

    public boolean isLessThan(PrimaryType collType) {
        return this.compareTo(collType) < 0;
    }

    public boolean isGreaterThan(PrimaryType collType) {
        return this.compareTo(collType) > 0;
    }

    public PrimaryType max(PrimaryType collType) {
        return this.isLessThan(collType) ? collType : this;
    }

    public PrimaryType min(PrimaryType collType) {
        return this.isLessThan(collType) ? this : collType;
    }

    public static PrimaryType get(char code) {
        switch (code) {
            case 'P': {
                return PRIMARY;
            }
            case 'S': {
                return SECONDARY;
            }
            case 'N': {
                return NOT_ELIGIBLE;
            }
        }
        throw new IllegalArgumentException("Cannot create collType from code " + code);
    }

    public static PrimaryType get(String code) {
        if (code == null) {
            return NOT_ELIGIBLE;
        }
        String codeText = code.trim();
        if (codeText.length() < 1) {
            return NOT_ELIGIBLE;
        }
        if (codeText.length() > 1) {
            throw new IllegalArgumentException("Cannot convert string '" + codeText + "' to a collType");
        }
        return PrimaryType.get(codeText.charAt(0));
    }

    public static List<PrimaryType> getAllTypes() {
        ArrayList<PrimaryType> types = new ArrayList<PrimaryType>();
        for (char c : s_order) {
            types.add(PrimaryType.get(c));
        }
        return types;
    }
}

