/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;

@XmlRootElement(name="outage")
@Entity
@Table(name="outages")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId join ipInterface on x.nodeid = ipInterface.nodeid join ifServices on ipInterface.id = ifServices.ipInterfaceId where ifServices.id = ifServiceId and cg.groupId in (:userGroups))")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsOutage
implements Serializable {
    private static final long serialVersionUID = 3846398168228820151L;
    private Integer m_id;
    private Date m_ifLostService;
    private Date m_ifRegainedService;
    private OnmsEvent m_serviceRegainedEvent;
    private OnmsEvent m_serviceLostEvent;
    private OnmsMonitoredService m_monitoredService;
    private Date m_suppressTime;
    private String m_suppressedBy;

    public OnmsOutage(Date ifLostService, Date ifRegainedService, OnmsEvent eventBySvcRegainedEvent, OnmsEvent eventBySvcLostEvent, OnmsMonitoredService monitoredService, Date suppressTime, String suppressedBy) {
        this.m_ifLostService = ifLostService;
        this.m_ifRegainedService = ifRegainedService;
        this.m_serviceRegainedEvent = eventBySvcRegainedEvent;
        this.m_serviceLostEvent = eventBySvcLostEvent;
        this.m_monitoredService = monitoredService;
        this.m_suppressTime = suppressTime;
        this.m_suppressedBy = suppressedBy;
    }

    public OnmsOutage() {
    }

    public OnmsOutage(Date ifLostService, OnmsMonitoredService monitoredService) {
        this.m_ifLostService = ifLostService;
        this.m_monitoredService = monitoredService;
    }

    public OnmsOutage(Date ifLostService, Date ifRegainedService, OnmsMonitoredService monitoredService) {
        this.m_ifLostService = ifLostService;
        this.m_ifRegainedService = ifRegainedService;
        this.m_monitoredService = monitoredService;
    }

    public OnmsOutage(Date ifLostService, OnmsEvent eventBySvcLostEvent, OnmsMonitoredService monitoredService) {
        this.m_ifLostService = ifLostService;
        this.m_serviceLostEvent = eventBySvcLostEvent;
        this.m_monitoredService = monitoredService;
    }

    @Id
    @XmlAttribute(name="id")
    @Column(name="outageId", nullable=false)
    @SequenceGenerator(name="outageSequence", sequenceName="outageNxtId")
    @GeneratedValue(generator="outageSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer outageId) {
        this.m_id = outageId;
    }

    @ManyToOne
    @JoinColumn(name="ifserviceId")
    public OnmsMonitoredService getMonitoredService() {
        return this.m_monitoredService;
    }

    public void setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_monitoredService = monitoredService;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ifLostService", nullable=false)
    public Date getIfLostService() {
        return this.m_ifLostService;
    }

    public void setIfLostService(Date ifLostService) {
        this.m_ifLostService = ifLostService;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="svcLostEventId")
    public OnmsEvent getServiceLostEvent() {
        return this.m_serviceLostEvent;
    }

    public void setServiceLostEvent(OnmsEvent svcLostEvent) {
        this.m_serviceLostEvent = svcLostEvent;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ifRegainedService")
    public Date getIfRegainedService() {
        return this.m_ifRegainedService;
    }

    public void setIfRegainedService(Date ifRegainedService) {
        this.m_ifRegainedService = ifRegainedService;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="svcRegainedEventId")
    public OnmsEvent getServiceRegainedEvent() {
        return this.m_serviceRegainedEvent;
    }

    public void setServiceRegainedEvent(OnmsEvent svcRegainedEvent) {
        this.m_serviceRegainedEvent = svcRegainedEvent;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="suppressTime")
    public Date getSuppressTime() {
        return this.m_suppressTime;
    }

    public void setSuppressTime(Date timeToSuppress) {
        this.m_suppressTime = timeToSuppress;
    }

    @Column(name="suppressedBy")
    public String getSuppressedBy() {
        return this.m_suppressedBy;
    }

    public void setSuppressedBy(String suppressorMan) {
        this.m_suppressedBy = suppressorMan;
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public OnmsNode getNode() {
        return this.getMonitoredService().getIpInterface().getNode();
    }

    public void setNode(OnmsNode node) {
        OnmsIpInterface intf;
        OnmsMonitoredService service = this.getMonitoredService();
        if (service == null) {
            service = new OnmsMonitoredService();
            this.setMonitoredService(service);
        }
        if ((intf = service.getIpInterface()) == null) {
            intf = new OnmsIpInterface();
            service.setIpInterface(intf);
        }
        intf.setNode(node);
    }

    @Transient
    @XmlElement(name="nodeId")
    public Integer getNodeId() {
        return this.getMonitoredService().getNodeId();
    }

    @Transient
    @XmlElement(name="nodeLabel")
    public String getNodeLabel() {
        return this.getMonitoredService().getIpInterface().getNode().getLabel();
    }

    @Transient
    @XmlElement(name="foreignSource")
    public String getForeignSource() {
        return this.getMonitoredService().getIpInterface().getNode().getForeignSource();
    }

    @Transient
    @XmlElement(name="foreignId")
    public String getForeignId() {
        return this.getMonitoredService().getIpInterface().getNode().getForeignId();
    }

    @Transient
    @XmlElement(name="locationName")
    public String getLocationName() {
        return this.getMonitoredService().getIpInterface().getNode().getLocation().getLocationName();
    }

    @Transient
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.getMonitoredService().getIpAddress();
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public String getIpAddressAsString() {
        return this.getMonitoredService().getIpAddressAsString();
    }

    @Transient
    public Integer getServiceId() {
        return this.getMonitoredService().getServiceId();
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public OnmsServiceType getServiceType() {
        return this.getMonitoredService().getServiceType();
    }

    public void setServiceType(OnmsServiceType type) {
        OnmsMonitoredService service = this.getMonitoredService();
        if (service == null) {
            service = new OnmsMonitoredService();
            this.setMonitoredService(service);
        }
        service.setServiceType(type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outageId", (Object)this.m_id).add("ifLostService", (Object)this.m_ifLostService).add("ifRegainedService", (Object)this.m_ifRegainedService).add("ifRegainedServiceEvent", (Object)this.m_serviceRegainedEvent).add("service", (Object)this.m_monitoredService).add("suppressedBy", (Object)this.m_suppressedBy).add("suppressTime", (Object)this.m_suppressTime).toString();
    }
}

