/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.HttpServerMethod;
import org.sblim.wbem.http.io.BoundedInputStream;
import org.sblim.wbem.http.io.ChunkedInputStream;
import org.sblim.wbem.http.io.PersistentInputStream;
import org.sblim.wbem.util.SessionProperties;

public class MessageReader {
    HttpHeader iHeader;
    HttpServerMethod iMethod;
    private boolean iChunked;
    private String iEncoding;
    InputStream iContent;

    public MessageReader(InputStream reader) throws IOException, HttpException {
        int contentLength;
        block8: {
            String contentType;
            String encoding;
            block7: {
                this.iChunked = false;
                this.iEncoding = "UTF-8";
                this.iMethod = new HttpServerMethod(reader);
                this.iHeader = new HttpHeader(reader);
                encoding = this.iHeader.getField("Transfer-Encoding");
                if (encoding != null && encoding.toLowerCase().endsWith("chunked")) {
                    this.iChunked = true;
                }
                String length = this.iHeader.getField("Content-Length");
                contentLength = -1;
                if (length != null) {
                    try {
                        contentLength = Integer.parseInt(length);
                    }
                    catch (Exception e) {
                        contentLength = -1;
                        Logger logger = SessionProperties.getGlobalProperties().getLogger();
                        if (!logger.isLoggable(Level.WARNING)) break block7;
                        logger.log(Level.WARNING, "invalid content length format from the response", e);
                    }
                }
            }
            if ((contentType = this.iHeader.getField("Content-Type")) != null) {
                try {
                    HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
                    encoding = contentTypeHeader.findValue("charset");
                }
                catch (Exception e) {
                    encoding = "UTF-8";
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block8;
                    logger.log(Level.WARNING, "invalid content type format from the response", e);
                }
            }
        }
        this.iContent = this.iChunked ? new ChunkedInputStream(new PersistentInputStream(reader, this.isPersistentConnectionSupported())) : new BoundedInputStream(new PersistentInputStream(reader, this.isPersistentConnectionSupported()), contentLength);
    }

    public String getCharacterEncoding() {
        return this.iEncoding;
    }

    public HttpHeader getHeader() {
        return this.iHeader;
    }

    public HttpServerMethod getMethod() {
        return this.iMethod;
    }

    public InputStream getInputStream() {
        return this.iContent;
    }

    public boolean isPersistentConnectionSupported() {
        String conn = this.iHeader.getField("Connection");
        if (conn != null) {
            if (conn.equalsIgnoreCase("close")) {
                return false;
            }
            if (conn.equalsIgnoreCase("Keep-Alive")) {
                return true;
            }
        }
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1;
    }

    public boolean isChunkSupported() {
        String TE;
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1 && (TE = this.iHeader.getField("TE")) != null && TE.equalsIgnoreCase("trailers");
    }

    public void close() throws IOException {
        this.iContent.close();
    }
}

