/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.util.SessionProperties;

public class HttpClientPool {
    private Vector iAllConnections = new Vector(1);
    private Vector iAvailableConnections = new Vector(1);
    private SessionProperties iSessionProperties = SessionProperties.getGlobalProperties();
    private boolean iClosed = false;
    private int iPoolSize = 10;

    public int getNumberOfAllConnections() {
        return this.iAllConnections.size();
    }

    public int getNumberOfAvailableConnections() {
        return this.iAvailableConnections.size();
    }

    public SessionProperties getSessionProperties() {
        return this.iSessionProperties;
    }

    public void setSessionProperties(SessionProperties pSessionProperties) {
        this.iSessionProperties = pSessionProperties != null ? pSessionProperties : SessionProperties.getGlobalProperties();
        this.iPoolSize = this.iSessionProperties.getConnectionPoolSize();
    }

    public synchronized HttpClient retrieveAvailableConnectionFromPool(URI pUri, AuthorizationHandler pHandler) {
        if (this.iClosed) {
            throw new IllegalStateException("HttpClientPool is closed. Retrieve connection failed.");
        }
        Logger logger = SessionProperties.getGlobalProperties().getLogger();
        if (this.getNumberOfAvailableConnections() > 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Reusing client (" + pUri.toString() + ", max: " + this.getPoolSize() + ", current:" + this.getNumberOfAvailableConnections());
            }
            return (HttpClient)this.iAvailableConnections.remove(0);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "New client (" + pUri.toString() + ", max: " + this.getPoolSize() + ", current:" + this.getNumberOfAvailableConnections());
        }
        HttpClient client = new HttpClient(pUri, this, pHandler);
        this.addConnectionToPool(client);
        return client;
    }

    public synchronized boolean returnAvailableConnectionToPool(HttpClient httpClient) {
        if (httpClient == null) {
            return false;
        }
        if (this.iClosed) {
            this.iAllConnections.remove(httpClient);
            httpClient.disconnect();
            return false;
        }
        if (this.iPoolSize > this.iAvailableConnections.size()) {
            if (!this.iAvailableConnections.contains(httpClient)) {
                this.addConnectionToPool(httpClient);
                this.iAvailableConnections.add(httpClient);
                return true;
            }
        } else {
            SessionProperties.getGlobalProperties().getLogger().log(Level.FINER, "Http pool size reached, discarding client.");
            this.iAllConnections.remove(httpClient);
            this.iAvailableConnections.remove(httpClient);
            httpClient.disconnect();
        }
        return false;
    }

    private boolean addConnectionToPool(HttpClient httpClient) {
        if (httpClient != null && !this.iAllConnections.contains(httpClient)) {
            this.iAllConnections.add(httpClient);
            return true;
        }
        return false;
    }

    public synchronized boolean removeConnectionFromPool(HttpClient httpClient) {
        if (httpClient != null) {
            this.iAvailableConnections.remove(httpClient);
            return this.iAllConnections.remove(httpClient);
        }
        return false;
    }

    public synchronized void closePool(boolean pKeepActive) {
        Iterator iter;
        this.iClosed = true;
        Iterator iterator = iter = pKeepActive ? this.iAvailableConnections.iterator() : this.iAllConnections.iterator();
        while (iter.hasNext()) {
            HttpClient httpClient = (HttpClient)iter.next();
            httpClient.disconnect();
        }
        if (pKeepActive) {
            this.iAllConnections.removeAll(this.iAvailableConnections);
        } else {
            this.iAllConnections.clear();
        }
        this.iAvailableConnections.clear();
    }

    protected void finalize() {
        this.closePool(true);
    }

    public int getPoolSize() {
        return this.iPoolSize;
    }
}

