/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.indications.CIMError;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.http.HttpContentHandler;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.MessageReader;
import org.sblim.wbem.http.MessageWriter;
import org.sblim.wbem.http.io.DebugInputStream;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIMClientXML_HelperImpl;
import org.sblim.wbem.xml.CIMRequest;
import org.sblim.wbem.xml.CIMXMLBuilderImpl;
import org.sblim.wbem.xml.CIMXMLParserImpl;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CIMIndicationHandler
extends HttpContentHandler {
    private CIMEventDispatcher iDispatcher = null;
    private SessionProperties iSessionProperties = SessionProperties.getGlobalProperties();
    private int iMessageId = 0;

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher) {
        this.iDispatcher = pDispatcher;
    }

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher, SessionProperties pProperties) {
        this.iDispatcher = pDispatcher;
        this.iSessionProperties = pProperties != null ? pProperties : SessionProperties.getGlobalProperties();
    }

    public void close() {
        if (this.iDispatcher != null) {
            this.iDispatcher.close();
        }
    }

    public synchronized int getMsgID() {
        ++this.iMessageId;
        if (this.iMessageId > 1000000) {
            this.iMessageId = 0;
        }
        return this.iMessageId;
    }

    public void handleContent(MessageReader pReader, MessageWriter pWriter, InetAddress pInetAddress) throws HttpException, IOException {
        CIMError error = null;
        HttpHeader inputHeader = pReader.getHeader();
        inputHeader = this.parseHeaders(inputHeader);
        String cimExport = inputHeader.getField("CIMExport");
        String cimOperation = inputHeader.getField("CIMOperation");
        String cimMethod = inputHeader.getField("CIMMethod");
        if (cimOperation != null && !"MethodCall".equalsIgnoreCase(cimOperation)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport != null && !"MethodRequest".equalsIgnoreCase(cimExport) && !"ExportMethodCall".equalsIgnoreCase(cimExport)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimOperation == null && cimExport == null) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        CIMRequest request = null;
        CIMClientXML_HelperImpl xmlHelper = null;
        try {
            xmlHelper = new CIMClientXML_HelperImpl();
        }
        catch (ParserConfigurationException e1) {
            IOException e = new IOException("ParserConfigurationException");
            e.initCause(e1);
            throw e;
        }
        InputStream inputstream = null;
        inputstream = this.iSessionProperties.isDebugInputStream() ? new DebugInputStream(pReader.getInputStream(), this.iSessionProperties.getDebugOutputStream()) : pReader.getInputStream();
        if (this.iSessionProperties.getXmlParser() == 2) {
            Document doc = null;
            try {
                doc = xmlHelper.parse(new InputSource(new InputStreamReader(inputstream, pReader.getCharacterEncoding())));
                if (this.iSessionProperties.isDebugXMLInput()) {
                    CIMClientXML_HelperImpl.dumpDocument(doc);
                }
                Element rootE = doc.getDocumentElement();
                request = (CIMRequest)CIMXMLParserImpl.parseCIM(rootE);
            }
            catch (Exception e) {
                Logger logger = this.iSessionProperties.getLogger();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "exception while parsing the XML with DOM parser", e);
                }
                throw new HttpException(400, "Bad Request");
            }
        }
        XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl(this.iSessionProperties.isDebugXMLInput());
        if (this.iSessionProperties.getXmlParser() == 1) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(new InputStreamReader(inputstream, pReader.getCharacterEncoding())), (DefaultHandler)hndlr);
            }
            catch (Exception e) {
                Logger logger = this.iSessionProperties.getLogger();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "exception while parsing the XML with XML parser", e);
                }
                throw new HttpException(400, "Bad Request");
            }
        }
        XMLPullParser pullParser = new XMLPullParser(new InputStreamReader(inputstream, pReader.getCharacterEncoding()));
        try {
            hndlr.parse(pullParser);
        }
        catch (Exception e) {
            Logger logger = this.iSessionProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "exception while parsing the XML with PullBased parser", e);
            }
            throw new HttpException(400, "Bad Request");
        }
        Vector o = hndlr.getObjects();
        request = (CIMRequest)o.elementAt(0);
        if (request == null) {
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport == null && !cimMethod.equalsIgnoreCase("Indication") || !request.isCIMExport()) {
            throw new HttpException(400, "Bad Request");
        }
        try {
            Vector paramValue = request.getParamValue();
            Iterator iter = paramValue.iterator();
            while (iter.hasNext()) {
                Object cimEvent = iter.next();
                if (!(cimEvent instanceof CIMInstance)) continue;
                CIMInstance indicationInst = (CIMInstance)cimEvent;
                String id = pReader.getMethod().getFile();
                id = id != null && id.startsWith("/") && id.length() > 1 && !id.equalsIgnoreCase("/cimom") ? id.substring(1) : "0";
                this.iDispatcher.dispatchEvent(new CIMEvent(indicationInst, id, pInetAddress));
            }
        }
        catch (Exception e) {
            error = new CIMError(CIMException.getStatusCode("CIM_ERR_FAILED"));
        }
        catch (Throwable t) {
            error = new CIMError(new CIMException("CIM_ERR_FAILED", t));
        }
        Document responseDoc = null;
        try {
            DocumentBuilder docBuilder = xmlHelper.getDocumentBuilder();
            responseDoc = docBuilder.newDocument();
            CIMXMLBuilderImpl.createIndication_response(responseDoc, request.getId(), error);
        }
        catch (Exception e) {
            throw new HttpException(400, "Bad Request");
        }
        CIMClientXML_HelperImpl.serialize(pWriter.getOutputStream(), responseDoc);
        pWriter.getHeader().addField("CIMExport", "MethodResponse");
    }

    private HttpHeader parseHeaders(HttpHeader pOriginalHeader) {
        String man = pOriginalHeader.getField("Man");
        String opt = pOriginalHeader.getField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.findValue("ns");
        }
        if (ns != null) {
            Iterator iter = pOriginalHeader.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry == null) continue;
                String key = entry.getKey().toString();
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), entry.getValue().toString());
                    continue;
                }
                headers.addField(key, entry.getValue().toString());
            }
        } else {
            headers = pOriginalHeader;
        }
        return headers;
    }
}

