/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import com.vmware.vim25.ws.SoapAction;
import com.vmware.vim25.ws.SoapClient;
import com.vmware.vim25.ws.TrustAllSSL;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public class WSClient
extends SoapClient {
    private static final Logger log = Logger.getLogger(WSClient.class);
    private final SSLSocketFactory sslSocketFactory;
    private XmlGen xmlGen = new XmlGenDom();

    public WSClient(String serverUrl) throws MalformedURLException, RemoteException {
        this(serverUrl, true);
    }

    public WSClient(String serverUrl, boolean ignoreCert) throws MalformedURLException, RemoteException {
        this(serverUrl, ignoreCert, null);
    }

    public WSClient(String serverUrl, boolean ignoreCert, TrustManager trustManager) throws MalformedURLException, RemoteException {
        if (ignoreCert && trustManager != null) {
            log.warn((Object)"The option to ignore certs has been set along with a provided trust manager. This is not a valid scenario and the trust manager will be ignored.");
        }
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        log.trace((Object)("Creating WSClient to server URL: " + serverUrl));
        log.trace((Object)("Ignore ssl: " + ignoreCert));
        this.trustManager = trustManager;
        this.baseUrl = new URL(serverUrl);
        this.sslSocketFactory = ignoreCert ? this.getTrustAllSocketFactory(true) : this.getCustomTrustManagerSocketFactory(trustManager);
    }

    @Override
    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        log.trace((Object)("Invoking method: " + methodName));
        String soapMsg = this.marshall(methodName, paras);
        InputStream is = null;
        try {
            is = this.post(soapMsg);
            log.trace((Object)("Converting xml response from server to: " + returnType));
            Object object = this.unMarshall(returnType, is);
            return object;
        }
        catch (Exception e1) {
            log.error((Object)("Exception caught while invoking method: " + methodName), (Throwable)e1);
            try {
                throw (RemoteException)e1;
            }
            catch (ClassCastException ignore) {
                throw new RemoteException("Exception caught trying to invoke method " + methodName, e1);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    @Override
    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        try {
            InputStream is = this.post(soapMsg);
            return this.readStream(is);
        }
        catch (Exception e) {
            throw new RemoteException("VI SDK invoke exception:" + e);
        }
    }

    protected InputStream post(String soapMsg) throws IOException {
        HttpURLConnection postCon = (HttpURLConnection)this.baseUrl.openConnection();
        if (this.sslSocketFactory != null && this.baseUrl.getProtocol().equalsIgnoreCase("https")) {
            ((HttpsURLConnection)postCon).setSSLSocketFactory(this.sslSocketFactory);
        }
        log.trace((Object)("POST: " + this.soapAction));
        log.trace((Object)("Payload: " + soapMsg));
        if (this.connectTimeout > 0) {
            postCon.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            postCon.setReadTimeout(this.readTimeout);
        }
        try {
            postCon.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            log.debug((Object)"ProtocolException caught.", (Throwable)e);
        }
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        String soapAction = this.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        postCon.setRequestProperty(SoapAction.SOAP_ACTION_HEADER.toString(), soapAction);
        postCon.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        if (this.cookie != null) {
            log.trace((Object)"Setting Cookie.");
            postCon.setRequestProperty("Cookie", this.cookie);
        }
        OutputStream os = postCon.getOutputStream();
        OutputStreamWriter out = this.createOutputStreamWriter(os);
        out.write(soapMsg);
        out.close();
        InputStream is = this.getInputStreamFromConnection(postCon);
        if (this.cookie == null) {
            this.cookie = postCon.getHeaderField("Set-Cookie");
            log.trace((Object)"Cookie was null. Fetching Set-Cookie header to get new Cookie.");
        }
        return is;
    }

    protected InputStream getInputStreamFromConnection(HttpURLConnection postCon) throws RemoteException {
        InputStream is;
        try {
            is = postCon.getInputStream();
            log.trace((Object)"Successfully fetched InputStream.");
        }
        catch (IOException ioe) {
            log.debug((Object)"Caught an IOException. Reading ErrorStream for results.", (Throwable)ioe);
            InputStream errorStream = postCon.getErrorStream();
            if (errorStream != null) {
                is = errorStream;
            }
            throw new RemoteException(MessageFormat.format("An error occurred getting a response from the connection at url {0}", this.baseUrl), ioe);
        }
        return is;
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream os) throws UnsupportedEncodingException {
        return new OutputStreamWriter(os, "UTF8");
    }

    protected SSLSocketFactory getTrustAllSocketFactory(boolean ignoreCert) throws RemoteException {
        return ignoreCert ? TrustAllSSL.getTrustContext().getSocketFactory() : null;
    }

    protected SSLSocketFactory getCustomTrustManagerSocketFactory(TrustManager tm) throws RemoteException {
        return tm != null ? CustomSSLTrustContextCreator.getTrustContext(tm).getSocketFactory() : null;
    }
}

