/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InvalidLocale;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NoClientCertificate;
import com.vmware.vim25.NoSubjectName;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SSPIChallenge;
import com.vmware.vim25.SessionManagerGenericServiceTicket;
import com.vmware.vim25.SessionManagerLocalTicket;
import com.vmware.vim25.SessionManagerServiceRequestSpec;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

public class SessionManager
extends ManagedObject {
    public SessionManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public UserSession getCurrentSession() {
        return (UserSession)this.getCurrentProperty("currentSession");
    }

    public String getDefaultLocale() {
        return (String)this.getCurrentProperty("defaultLocale");
    }

    public String getMessage() {
        return (String)this.getCurrentProperty("message");
    }

    public String[] getMessageLocaleList() {
        return (String[])this.getCurrentProperty("messageLocaleList");
    }

    public UserSession[] getSessionList() {
        return (UserSession[])this.getCurrentProperty("sessionList");
    }

    public String[] getSupportedLocaleList() {
        return (String[])this.getCurrentProperty("supportedLocaleList");
    }

    public SessionManagerLocalTicket acquireLocalTicket(String userName) throws InvalidLogin, RuntimeFault, RemoteException {
        return this.getVimService().acquireLocalTicket(this.getMOR(), userName);
    }

    public SessionManagerGenericServiceTicket acquireGenericServiceTicket(SessionManagerServiceRequestSpec spec) throws RuntimeFault, RemoteException {
        return this.getVimService().acquireGenericServiceTicket(this.getMOR(), spec);
    }

    public UserSession cloneSession(String cloneTicket) throws InvalidLogin, RuntimeFault, RemoteException {
        return this.getVimService().cloneSession(this.getMOR(), cloneTicket);
    }

    public ServiceInstance cloneSession(boolean ignoreCert) throws InvalidLogin, RuntimeFault, RemoteException, MalformedURLException {
        ServiceInstance oldsi = this.getServerConnection().getServiceInstance();
        ServerConnection oldsc = oldsi.getServerConnection();
        String ticket = oldsi.getSessionManager().acquireCloneTicket();
        VimPortType vimService = new VimPortType(oldsc.getUrl().toString(), ignoreCert);
        vimService.getWsc().setVimNameSpace(oldsc.getVimService().getWsc().getVimNameSpace());
        vimService.getWsc().setSoapActionOnApiVersion(oldsi.getAboutInfo().getApiVersion());
        ServerConnection newsc = new ServerConnection(oldsc.getUrl(), vimService, null);
        ServiceInstance newsi = new ServiceInstance(newsc);
        newsc.setServiceInstance(newsi);
        UserSession userSession = newsi.getSessionManager().cloneSession(ticket);
        newsc.setUserSession(userSession);
        return newsi;
    }

    public String acquireCloneTicket() throws RuntimeFault, RemoteException {
        return this.getVimService().acquireCloneTicket(this.getMOR());
    }

    public UserSession loginExtensionBySubjectName(String extensionKey, String locale) throws InvalidLogin, InvalidLocale, NotFound, NoClientCertificate, NoSubjectName, RuntimeFault, RemoteException {
        return this.getVimService().loginExtensionBySubjectName(this.getMOR(), extensionKey, locale);
    }

    public UserSession loginExtensionByCertificate(String extensionKey, String locale) throws InvalidLogin, InvalidLocale, NoClientCertificate, RuntimeFault, RemoteException {
        return this.getVimService().loginExtensionByCertificate(this.getMOR(), extensionKey, locale);
    }

    public UserSession impersonateUser(String userName, String locale) throws InvalidLogin, InvalidLocale, RuntimeFault, RemoteException {
        return this.getVimService().impersonateUser(this.getMOR(), userName, locale);
    }

    public UserSession login(String userName, String password, String locale) throws InvalidLogin, InvalidLocale, RuntimeFault, RemoteException {
        return this.getVimService().login(this.getMOR(), userName, password, locale);
    }

    public UserSession loginBySSPI(String base64Token, String locale) throws InvalidLogin, InvalidLocale, SSPIChallenge, RuntimeFault, RemoteException {
        return this.getVimService().loginBySSPI(this.getMOR(), base64Token, locale);
    }

    public UserSession loginByToken(String locale) throws InvalidLogin, InvalidLocale, RuntimeFault, RemoteException {
        return this.getVimService().loginByToken(this.getMOR(), locale);
    }

    public void logout() throws RuntimeFault, RemoteException {
        this.getVimService().logout(this.getMOR());
    }

    public boolean sessionIsActive(String sessionID, String userName) throws RuntimeFault, RemoteException {
        return this.getVimService().sessionIsActive(this.getMOR(), sessionID, userName);
    }

    public void setLocale(String locale) throws InvalidLocale, RuntimeFault, RemoteException {
        this.getVimService().setLocale(this.getMOR(), locale);
    }

    public void terminateSession(String[] sessionIDs) throws NotFound, RuntimeFault, RemoteException {
        this.getVimService().terminateSession(this.getMOR(), sessionIDs);
    }

    public void updateServiceMessage(String message) throws RuntimeFault, RemoteException {
        this.getVimService().updateServiceMessage(this.getMOR(), message);
    }
}

