/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.PropertyFilter;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ScheduledTask;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.View;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.mo.util.PropertyCollectorUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class ManagedObject {
    private static String MO_PACKAGE_NAME = null;
    private static Logger log = Logger.getLogger(ManagedObject.class);
    private ServerConnection serverConnection = null;
    private ManagedObjectReference mor = null;

    protected ManagedObject() {
    }

    public ManagedObject(ServerConnection serverConnection, ManagedObjectReference mor) {
        this.serverConnection = serverConnection;
        this.mor = mor;
    }

    protected void setMOR(ManagedObjectReference mor) {
        this.mor = mor;
    }

    public ManagedObjectReference getMOR() {
        return this.mor;
    }

    protected VimPortType getVimService() {
        return this.serverConnection.getVimService();
    }

    public ServerConnection getServerConnection() {
        return this.serverConnection;
    }

    protected void setServerConnection(ServerConnection sc) {
        if (this.serverConnection == null) {
            this.serverConnection = sc;
        }
    }

    protected ObjectContent retrieveObjectProperties(String[] properties) {
        ObjectContent[] objs;
        ObjectSpec oSpec = PropertyCollectorUtil.creatObjectSpec(this.getMOR(), Boolean.FALSE, null);
        PropertySpec pSpec = PropertyCollectorUtil.createPropertySpec(this.getMOR().getType(), properties == null || properties.length == 0, properties);
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        PropertyCollector pc = this.getServerConnection().getServiceInstance().getPropertyCollector();
        try {
            objs = pc.retrieveProperties(new PropertyFilterSpec[]{pfSpec});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (objs == null || objs[0] == null) {
            return null;
        }
        return objs[0];
    }

    protected Object getCurrentProperty(String propertyName) {
        DynamicProperty[] dynaProps;
        ObjectContent objContent = this.retrieveObjectProperties(new String[]{propertyName});
        Object propertyValue = null;
        if (objContent != null && (dynaProps = objContent.getPropSet()) != null && dynaProps[0] != null) {
            propertyValue = PropertyCollectorUtil.convertProperty(dynaProps[0].getVal());
        }
        return propertyValue;
    }

    public Object getPropertyByPath(String propPath) {
        return this.getCurrentProperty(propPath);
    }

    public Hashtable getPropertiesByPaths(String[] propPaths) throws InvalidProperty, RuntimeFault, RemoteException {
        Hashtable[] pht = PropertyCollectorUtil.retrieveProperties(new ManagedObject[]{this}, this.getMOR().getType(), propPaths);
        if (pht.length != 0) {
            return pht[0];
        }
        return null;
    }

    protected ManagedObject[] getManagedObjects(String propName, boolean mixedType) {
        Object object = this.getCurrentProperty(propName);
        ManagedObjectReference[] mors = null;
        if (object instanceof ManagedObjectReference[]) {
            mors = (ManagedObjectReference[])object;
        }
        if (mors == null || mors.length == 0) {
            return new ManagedObject[0];
        }
        Object mos = new ManagedObject[mors.length];
        try {
            Class<?> moClass = null;
            if (!mixedType) {
                moClass = Class.forName(MO_PACKAGE_NAME + "." + mors[0].getType());
                mos = Array.newInstance(moClass, mors.length);
            }
            for (int i = 0; i < mors.length; ++i) {
                if (mixedType) {
                    moClass = Class.forName(MO_PACKAGE_NAME + "." + mors[i].getType());
                }
                Constructor<?> constructor = moClass.getConstructor(ServerConnection.class, ManagedObjectReference.class);
                Array.set(mos, i, constructor.newInstance(this.getServerConnection(), mors[i]));
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception caught trying to getManagedObjects.", (Throwable)e);
        }
        return mos;
    }

    protected ManagedObject[] getManagedObjects(String propName) {
        return this.getManagedObjects(propName, false);
    }

    protected Datastore[] getDatastores(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new Datastore[0];
        }
        return (Datastore[])objs;
    }

    protected Network[] getNetworks(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName, true);
        if (objs.length == 0) {
            return new Network[0];
        }
        Network[] nets = new Network[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            nets[i] = (Network)objs[i];
        }
        return nets;
    }

    protected VirtualMachine[] getVms(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new VirtualMachine[0];
        }
        return (VirtualMachine[])objs;
    }

    protected PropertyFilter[] getFilter(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new PropertyFilter[0];
        }
        return (PropertyFilter[])objs;
    }

    protected ResourcePool[] getResourcePools(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName, true);
        ResourcePool[] rps = new ResourcePool[objs.length];
        for (int i = 0; i < rps.length; ++i) {
            rps[i] = (ResourcePool)objs[i];
        }
        return rps;
    }

    protected Task[] getTasks(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new Task[0];
        }
        return (Task[])objs;
    }

    protected ScheduledTask[] getScheduledTasks(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new ScheduledTask[0];
        }
        return (ScheduledTask[])objs;
    }

    protected View[] getViews(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new View[0];
        }
        return (View[])objs;
    }

    protected HostSystem[] getHosts(String propName) {
        ManagedObject[] objs = this.getManagedObjects(propName);
        if (objs.length == 0) {
            return new HostSystem[0];
        }
        return (HostSystem[])objs;
    }

    protected ManagedObject getManagedObject(String propName) {
        ManagedObjectReference mor = (ManagedObjectReference)this.getCurrentProperty(propName);
        return MorUtil.createExactManagedObject(this.getServerConnection(), mor);
    }

    protected Object[] waitForValues(String[] filterProps, String[] endWaitProps, Object[][] expectedVals) throws InvalidProperty, RuntimeFault, RemoteException {
        String version = "";
        Object[] endVals = new Object[endWaitProps.length];
        Object[] filterVals = new Object[filterProps.length];
        ObjectSpec oSpec = PropertyCollectorUtil.creatObjectSpec(this.getMOR(), Boolean.FALSE, null);
        PropertySpec pSpec = PropertyCollectorUtil.createPropertySpec(this.getMOR().getType(), filterProps == null || filterProps.length == 0, filterProps);
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setObjectSet(new ObjectSpec[]{oSpec});
        spec.setPropSet(new PropertySpec[]{pSpec});
        PropertyCollector pc = this.serverConnection.getServiceInstance().getPropertyCollector();
        PropertyFilter pf = pc.createFilter(spec, true);
        boolean reached = false;
        while (!reached) {
            UpdateSet updateset = pc.waitForUpdatesEx(version, null);
            if (updateset == null) continue;
            version = updateset.getVersion();
            PropertyFilterUpdate[] filtupary = updateset.getFilterSet();
            if (filtupary == null) continue;
            for (PropertyFilterUpdate filtup : filtupary) {
                if (filtup == null) continue;
                ObjectUpdate[] objupary = filtup.getObjectSet();
                for (int j = 0; objupary != null && j < objupary.length; ++j) {
                    ObjectUpdate objup = objupary[j];
                    if (objup == null) continue;
                    PropertyChange[] propchgary = objup.getChangeSet();
                    for (int k = 0; propchgary != null && k < propchgary.length; ++k) {
                        PropertyChange propchg = propchgary[k];
                        this.updateValues(endWaitProps, endVals, propchg);
                        this.updateValues(filterProps, filterVals, propchg);
                    }
                }
            }
            for (int chgi = 0; chgi < endVals.length && !reached; ++chgi) {
                for (int vali = 0; vali < expectedVals[chgi].length && !reached; ++vali) {
                    Object expctdval = expectedVals[chgi][vali];
                    reached = expctdval.equals(endVals[chgi]) || reached;
                }
            }
        }
        pf.destroyPropertyFilter();
        return filterVals;
    }

    private void updateValues(String[] props, Object[] vals, PropertyChange propchg) {
        for (int i = 0; i < props.length; ++i) {
            if (propchg.getName().lastIndexOf(props[i]) < 0) continue;
            vals[i] = propchg.getOp() == PropertyChangeOp.remove ? "" : propchg.getVal();
        }
    }

    public String toString() {
        return this.mor.getType() + ":" + this.mor.get_value() + " @ " + this.getServerConnection().getUrl();
    }

    protected ManagedObjectReference[] convertMors(ManagedObject[] mos) {
        ManagedObjectReference[] mors = null;
        if (mos != null) {
            mors = MorUtil.createMORs(mos);
        }
        return mors;
    }

    static {
        MO_PACKAGE_NAME = ManagedObject.class.getPackage().getName();
    }
}

