/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.annotation.Priority;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.ops4j.pax.web.service.jetty.internal.ServerControllerFactoryImpl;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceRegistration registration;
    private ServiceTracker<Handler, Handler> handlerTracker;
    private BundleContext bundleContext;
    private ServiceTracker<Connector, Connector> connectorTracker;
    private ServiceTracker<HttpConfiguration.Customizer, HttpConfiguration.Customizer> customizerTracker;
    private ServerControllerFactoryImpl serverControllerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        PriorityComparator comparator;
        this.bundleContext = bundleContext;
        for (Bundle b : bundleContext.getBundles()) {
            if (!"org.eclipse.jetty.util".equals(b.getSymbolicName())) continue;
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                ShutdownThread.getInstance().setContextClassLoader(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader());
            }
            finally {
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
        Bundle bundle = bundleContext.getBundle();
        try {
            bundle.loadClass("javax.annotation.Priority");
            comparator = new PriorityComparator();
        }
        catch (ClassNotFoundException e) {
            comparator = null;
        }
        this.serverControllerFactory = new ServerControllerFactoryImpl(bundle, comparator);
        this.handlerTracker = new ServiceTracker(bundleContext, Handler.class, (ServiceTrackerCustomizer)new HandlerCustomizer());
        this.handlerTracker.open();
        this.connectorTracker = new ServiceTracker(bundleContext, Connector.class, (ServiceTrackerCustomizer)new ConnectorCustomizer());
        this.connectorTracker.open();
        this.customizerTracker = new ServiceTracker(bundleContext, HttpConfiguration.Customizer.class, (ServiceTrackerCustomizer)new CustomizerCustomizer());
        this.customizerTracker.open();
        this.registration = bundleContext.registerService(ServerControllerFactory.class, (Object)this.serverControllerFactory, new Hashtable());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.registration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connectorTracker.close();
        this.handlerTracker.close();
        this.customizerTracker.close();
    }

    private class CustomizerCustomizer
    implements ServiceTrackerCustomizer<HttpConfiguration.Customizer, HttpConfiguration.Customizer> {
        private CustomizerCustomizer() {
        }

        public HttpConfiguration.Customizer addingService(ServiceReference<HttpConfiguration.Customizer> reference) {
            HttpConfiguration.Customizer customizer = (HttpConfiguration.Customizer)Activator.this.bundleContext.getService(reference);
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            Activator.this.serverControllerFactory.addCustomizer(customizer, ranking == null ? 0 : ranking);
            return customizer;
        }

        public void modifiedService(ServiceReference<HttpConfiguration.Customizer> reference, HttpConfiguration.Customizer service) {
        }

        public void removedService(ServiceReference<HttpConfiguration.Customizer> reference, HttpConfiguration.Customizer customizer) {
            Activator.this.bundleContext.ungetService(reference);
            try {
                Activator.this.serverControllerFactory.removeCustomizer(customizer);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private class ConnectorCustomizer
    implements ServiceTrackerCustomizer<Connector, Connector> {
        private ConnectorCustomizer() {
        }

        public Connector addingService(ServiceReference<Connector> reference) {
            Connector connector = (Connector)Activator.this.bundleContext.getService(reference);
            if (Activator.this.registration != null) {
                Activator.this.registration.unregister();
            }
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            Activator.this.serverControllerFactory.addConnector(connector, ranking == null ? 0 : ranking);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            return connector;
        }

        public void modifiedService(ServiceReference<Connector> reference, Connector service) {
        }

        public void removedService(ServiceReference<Connector> reference, Connector connector) {
            Activator.this.bundleContext.ungetService(reference);
            try {
                if (Activator.this.registration != null) {
                    Activator.this.registration.unregister();
                }
                Activator.this.serverControllerFactory.removeConnector(connector);
                Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private class HandlerCustomizer
    implements ServiceTrackerCustomizer<Handler, Handler> {
        private HandlerCustomizer() {
        }

        public Handler addingService(ServiceReference<Handler> reference) {
            Handler handler = (Handler)Activator.this.bundleContext.getService(reference);
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            if (Activator.this.registration != null) {
                Activator.this.registration.unregister();
            }
            Activator.this.serverControllerFactory.addHandler(handler, ranking == null ? 0 : ranking);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            return handler;
        }

        public void modifiedService(ServiceReference<Handler> reference, Handler service) {
        }

        public void removedService(ServiceReference<Handler> reference, Handler handler) {
            Activator.this.bundleContext.ungetService(reference);
            try {
                Activator.this.serverControllerFactory.removeHandler(handler);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static class PriorityComparator
    implements Comparator<Object> {
        private PriorityComparator() {
        }

        @Override
        public int compare(Object element1, Object element2) {
            Integer comparison = 0;
            if (element1 != element2) {
                comparison = null;
                for (Object element : Arrays.asList(element1, element2)) {
                    Priority annotation = element.getClass().getAnnotation(Priority.class);
                    int priority = annotation == null ? 0 : annotation.value();
                    comparison = comparison == null ? priority : comparison - priority;
                }
            }
            return comparison;
        }
    }
}

