/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.jexl2.JexlContext;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.JexlIndexStorageStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectNameStorageStrategy
extends JexlIndexStorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectNameStorageStrategy.class);
    private static final String QUOTE = "\"";

    @Override
    public void updateContext(JexlContext context, CollectionResource resource) throws IllegalArgumentException {
        try {
            ObjectName oname = new ObjectName(resource.getUnmodifiedInstance());
            context.set("ObjectName", (Object)oname);
            context.set("domain", (Object)(oname.getDomain() == null ? "" : oname.getDomain()));
            oname.getKeyPropertyList().entrySet().forEach(entry -> {
                String value = (String)entry.getValue();
                if (value.startsWith(QUOTE) && value.endsWith(QUOTE)) {
                    context.set((String)entry.getKey(), (Object)ObjectName.unquote((String)entry.getValue()));
                } else {
                    context.set((String)entry.getKey(), entry.getValue());
                }
            });
        }
        catch (MalformedObjectNameException e) {
            String msg = "Malformed ObjectName: " + resource.getUnmodifiedInstance();
            LOG.error("getResourceNameFromIndex(): {}", (Object)msg, (Object)e);
            throw new IllegalArgumentException(msg);
        }
    }
}

