/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.util.function.Function;
import org.opennms.netmgt.collection.api.DelegatingResourceType;
import org.opennms.netmgt.collection.api.ResourceType;

public class ResourceTypeMapper {
    private static ResourceTypeMapper instance;
    private Function<String, ResourceType> mapper;

    private ResourceTypeMapper() {
    }

    public static ResourceTypeMapper getInstance() {
        if (instance == null) {
            instance = new ResourceTypeMapper();
        }
        return instance;
    }

    public void setResourceTypeMapper(Function<String, ResourceType> mapper) {
        this.mapper = mapper;
    }

    public ResourceType getResourceType(String name) {
        if (this.mapper != null) {
            return this.mapper.apply(name);
        }
        return null;
    }

    public ResourceType getResourceTypeWithFallback(final String name, String fallback) {
        if (this.mapper == null) {
            return null;
        }
        ResourceType rt = this.mapper.apply(name);
        if (rt != null) {
            return rt;
        }
        if (fallback != null && (rt = this.mapper.apply(fallback)) != null) {
            return new DelegatingResourceType(rt){

                @Override
                public String getName() {
                    return name;
                }
            };
        }
        return null;
    }
}

