/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.mailtransporttest.MailTransportTest;
import org.opennms.netmgt.config.mailtransporttest.ReadmailHost;
import org.opennms.netmgt.config.mailtransporttest.ReadmailTest;
import org.opennms.netmgt.config.mailtransporttest.SendmailTest;
import org.opennms.netmgt.config.mailtransporttest.UserAuth;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;

public class MailTransportParameters {
    public static final String KEY = MailTransportParameters.class.getName();
    private static final int DEFAULT_RETRY = 1;
    private static final int DEFAULT_TIMEOUT = 3000;
    private Map<String, Object> m_parameterMap;
    private MailTransportTest m_transportTest;
    private String m_testSubjectSuffix;
    private boolean m_end2EndTestInProgress = false;
    private Properties m_javamailProperties = new Properties();

    MailTransportParameters(Map<String, Object> parameterMap) {
        this.m_parameterMap = parameterMap;
        Object mailTransportTest = AbstractServiceMonitor.getKeyedObject(this.m_parameterMap, (String)"mail-transport-test", null);
        if (mailTransportTest == null) {
            throw new IllegalArgumentException("mail-transport-test must be set in monitor parameters");
        }
        if (mailTransportTest instanceof MailTransportTest) {
            this.m_transportTest = (MailTransportTest)mailTransportTest;
        } else if (mailTransportTest instanceof String) {
            this.m_transportTest = (MailTransportTest)JaxbUtils.unmarshal(MailTransportTest.class, (String)((String)mailTransportTest));
        } else {
            throw new IllegalArgumentException("Unsure how to deal with Mail Transport Test of type " + mailTransportTest.getClass());
        }
    }

    static synchronized MailTransportParameters get(Map<String, Object> parameterMap) {
        MailTransportParameters parms = (MailTransportParameters)parameterMap.get(KEY);
        if (parms == null) {
            parms = new MailTransportParameters(parameterMap);
            parameterMap.put(KEY, parms);
        }
        return parms;
    }

    Map<String, Object> getParameterMap() {
        return this.m_parameterMap;
    }

    MailTransportTest getTransportTest() {
        return this.m_transportTest;
    }

    private int getIntParm(String key, int defValue) {
        return ParameterMap.getKeyedInteger(this.getParameterMap(), (String)key, (int)defValue);
    }

    public int getRetries() {
        return this.getIntParm("retry", 1);
    }

    public int getTimeout() {
        return this.getIntParm("timeout", 3000);
    }

    public String getReadTestPassword() {
        if (this.getReadTest().getUserAuth().isPresent()) {
            return ((UserAuth)this.getReadTest().getUserAuth().get()).getPassword();
        }
        return null;
    }

    ReadmailTest getReadTest() {
        return this.getTransportTest().getMailTest().getReadmailTest();
    }

    public String getTestSubjectSuffix() {
        return this.m_testSubjectSuffix;
    }

    public void setTestSubjectSuffix(String suffix) {
        this.m_testSubjectSuffix = suffix;
    }

    public String getComputedTestSubject() {
        try {
            String subject = this.getSendTestSubject();
            String suffix = this.getTestSubjectSuffix();
            if (subject != null) {
                return subject + ':' + (suffix == null ? "" : suffix);
            }
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    String getSendTestFrom() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getFrom();
    }

    public boolean isSendTestUseAuth() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getUseAuthentication();
    }

    public String getSendTestCharSet() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getCharSet();
    }

    public String getSendTestMessageContentType() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMessageContentType();
    }

    public boolean isSendTestDebug() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getDebug();
    }

    public String getSendTestMessageEncoding() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMessageEncoding();
    }

    public String getSendTestMailer() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMailer();
    }

    public String getSendTestHost() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailHost().getHost();
    }

    public String getSendTestMessageBody() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getBody();
    }

    public String getSendTestPassword() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        if (this.getSendTest().getUserAuth().isPresent()) {
            return ((UserAuth)this.getSendTest().getUserAuth().get()).getPassword();
        }
        return null;
    }

    public boolean isSendTestIsQuitWait() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getQuitWait();
    }

    public int getSendTestPort() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        Long port = this.getSendTest().getSendmailHost().getPort();
        return port == null ? 0 : port.intValue();
    }

    public boolean isSendTestIsSslEnable() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getSslEnable();
    }

    public boolean isSendTestStartTls() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getStartTls();
    }

    public String getSendTestSubject() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getSubject();
    }

    public String getSendTestRecipeint() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getTo();
    }

    public String getSendTestTransport() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getTransport();
    }

    public boolean isSendTestUseJmta() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for sendmail parameters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getUseJmta();
    }

    public String getSendTestUserName() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for sendmail parameters invalid due to no sendmail specification in config");
        }
        if (this.getSendTest().getUserAuth().isPresent()) {
            return ((UserAuth)this.getSendTest().getUserAuth().get()).getUserName();
        }
        return null;
    }

    SendmailTest getSendTest() {
        return this.getTransportTest().getMailTest().getSendmailTest();
    }

    public String getReadTestHost() {
        ReadmailHost readmailHost;
        ReadmailTest readTest = this.getReadTest();
        if (readTest != null && (readmailHost = readTest.getReadmailHost()) != null) {
            return readmailHost.getHost();
        }
        return null;
    }

    public int getReadTestPort() {
        Long port = this.getReadTest().getReadmailHost().getPort();
        return port == null ? 0 : port.intValue();
    }

    public String getReadTestUserName() {
        if (this.getReadTest().getUserAuth().isPresent()) {
            return ((UserAuth)this.getReadTest().getUserAuth().get()).getUserName();
        }
        return null;
    }

    public String getReadTestFolder() {
        return this.getReadTest().getMailFolder();
    }

    public String getReadTestProtocol() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().getTransport();
    }

    public boolean isReadTestStartTlsEnabled() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().shouldStartTLS();
    }

    public boolean isReadTestSslEnabled() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().isSslEnabled();
    }

    public void setEnd2EndTestInProgress(boolean b) {
        this.m_end2EndTestInProgress = b;
    }

    public boolean isEnd2EndTestInProgress() {
        return this.m_end2EndTestInProgress;
    }

    public long getReadTestAttemptInterval() {
        return this.getReadTest().getAttemptInterval();
    }

    public long getSendTestAttemptInterval() {
        return this.getSendTest().getAttemptInterval();
    }

    public Properties getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(Properties props) {
        this.m_javamailProperties = props;
    }

    public void setReadTestHost(String host) {
        this.getReadTest().getReadmailHost().setHost(host);
    }

    public void setSendTestHost(String host) {
        this.getSendTest().getSendmailHost().setHost(host);
    }
}

