/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.Scope;

public class MapScope
implements Scope {
    private final Map<ContextKey, String> values;

    public MapScope(Map<ContextKey, String> values) {
        this.values = Objects.requireNonNull(values);
    }

    @Override
    public Optional<String> get(ContextKey contextKey) {
        return Optional.ofNullable(this.values.get(contextKey));
    }

    @Override
    public Set<ContextKey> keys() {
        return this.values.keySet();
    }

    public static MapScope singleContext(String context, Map<String, String> values) {
        return new MapScope(values.entrySet().stream().collect(Collectors.toMap(e -> new ContextKey(context, (String)e.getKey()), e -> (String)e.getValue())));
    }
}

