/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Map;
import java.util.Properties;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.utils.SystemInfoUtils;

public class OnmsKafkaConfigProvider
implements KafkaConfigProvider {
    private final String kafkaSysPropPrefix;

    public OnmsKafkaConfigProvider(String kafkaSysPropPrefix) {
        this.kafkaSysPropPrefix = kafkaSysPropPrefix;
    }

    @Override
    public Properties getProperties() {
        Properties kafkaConfig = new Properties();
        kafkaConfig.put("group.id", SystemInfoUtils.getInstanceId());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            Object keyAsObject = entry.getKey();
            if (keyAsObject == null || !(keyAsObject instanceof String) || (key = (String)keyAsObject).length() <= this.kafkaSysPropPrefix.length() || !key.startsWith(this.kafkaSysPropPrefix)) continue;
            String kafkaConfigKey = key.substring(this.kafkaSysPropPrefix.length());
            kafkaConfig.put(kafkaConfigKey, entry.getValue());
        }
        return kafkaConfig;
    }
}

