/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

class IsolatingClassLoader
extends URLClassLoader {
    private String[] m_isolatedPrefixes;
    private final Set<String> m_isolatedClassNames = new HashSet<String>();

    public IsolatingClassLoader(String name, URL[] classpath, ClassLoader parent, String[] isolated, boolean augmentClassPath) throws InvalidContextClassLoaderException {
        super(classpath, parent);
        this.init(name, isolated, augmentClassPath);
    }

    private void init(String name, String[] isolated, boolean augmentClassPath) throws InvalidContextClassLoaderException {
        HashSet<String> prefixes = new HashSet<String>();
        for (String element : isolated) {
            int index = element.indexOf(42);
            if (index >= 0) {
                prefixes.add(element.substring(0, index));
                continue;
            }
            this.m_isolatedClassNames.add(element);
        }
        this.m_isolatedPrefixes = prefixes.toArray(new String[0]);
        if (augmentClassPath) {
            ClassLoader callerClassLoader = Thread.currentThread().getContextClassLoader();
            if (callerClassLoader instanceof URLClassLoader) {
                URL[] newURLs;
                for (URL newURL : newURLs = ((URLClassLoader)callerClassLoader).getURLs()) {
                    this.addURL(newURL);
                }
            } else {
                throw new InvalidContextClassLoaderException("Caller classloader is not a URLClassLoader, can't automatically augument classpath.Its a " + callerClassLoader.getClass());
            }
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean isolated = this.m_isolatedClassNames.contains(name);
        if (!isolated) {
            for (String prefix : this.m_isolatedPrefixes) {
                if (!name.startsWith(prefix)) continue;
                isolated = true;
                break;
            }
        }
        if (isolated) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    public static class InvalidContextClassLoaderException
    extends Exception {
        private static final long serialVersionUID = -82741827583768184L;

        public InvalidContextClassLoaderException(String message) {
            super(message);
        }
    }
}

